/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FrogHealProjectile
extends BaseProjectile {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private LivingEntity target;

    public FrogHealProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.5), this::canHitEntity);
    }

    protected boolean canHitEntity(@NotNull Entity pTarget) {
        if (pTarget == this.getOwner()) {
            return false;
        }
        return Util.areEntitiesLinked((Entity)this, pTarget);
    }

    public float getDefaultSpeed() {
        return 0.425f;
    }

    public float getDefaultLerp() {
        return 0.28f;
    }

    public void spawnRibbon() {
        Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), 0.88235295f, 1.0f, 0.85490197f, 0.0f, 0.35f);
    }

    public void spawnParticles() {
        if (this.tickCount % 8 == 0) {
            this.level().addParticle((ParticleOptions)KnightLibParticles.STARSET.get(), this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tick() {
        Vec3 v;
        super.tick();
        if (!this.level().isClientSide && this.target != null && this.target.isAlive()) {
            v = this.target.getEyePosition().subtract(this.position()).normalize().scale((double)this.getDefaultSpeed());
            this.setDeltaMovement(this.getDeltaMovement().lerp(v, (double)this.getDefaultLerp()).normalize().scale((double)this.getDefaultSpeed()));
            this.hasImpulse = true;
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            v = this.getDeltaMovement();
            this.setYRot((float)(Mth.atan2((double)v.x, (double)v.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)v.y, (double)v.horizontalDistance()) * 57.2957763671875));
        }
        this.spawnParticles();
        if (!this.onGround()) {
            Vec3 pos = this.position();
            Vec3 vec33 = pos.add(this.getDeltaMovement());
            BlockHitResult hitresult = this.level().clip(new ClipContext(pos, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                vec33 = hitresult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(pos, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player) {
                        Player p2;
                        Player p1 = (Player)entity;
                        if (entity1 instanceof Player && !p1.canHarmPlayer(p2 = (Player)entity1)) {
                            hitresult = null;
                            entityhitresult = null;
                        }
                    }
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS) {
                    this.onHit((HitResult)hitresult);
                    this.hasImpulse = true;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            this.checkInsideBlocks();
        }
        if (this.onGround()) {
            this.discard();
        }
        if (this.level().isClientSide && (this.tickCount % 20 == 0 || this.tickCount == 1)) {
            this.spawnRibbon();
        }
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        super.remove(pReason);
    }

    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        Entity e = pResult.getEntity();
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.25;
            double dy = (this.random.nextDouble() - 0.5) * 1.25;
            double dz = (this.random.nextDouble() - 0.5) * 1.25;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.35f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, e.getX(), e.getY() + 0.15, e.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.65f)) continue;
            level2.sendParticles((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), e.getX(), e.getY() + 0.15, e.getZ(), 1, dx, dy, dz, 0.1);
        }
        if (e instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)e;
            entity.heal((float)CompanionsConfig.ENDER_FROG_HEAL_PROJECTILE_HEAL_AMOUNT);
        }
        this.playSound(CompanionsSounds.END_FROG_HEAL.get());
        this.discard();
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }
}

