/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.BlueStarExplosion;
import dev.xylonity.companions.common.entity.projectile.BlueStarExplosionCenter;
import dev.xylonity.companions.common.entity.projectile.RedStarExplosion;
import dev.xylonity.companions.common.entity.projectile.RedStarExplosionCenter;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.mixin.CompanionsProjectileAccessor;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class HolinessStartProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> RED = SynchedEntityData.defineId(HolinessStartProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static float SPEED = 0.6f;
    private LivingEntity target;

    public HolinessStartProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(@NotNull Entity pTarget) {
        if (Util.areEntitiesLinked((Entity)this, pTarget)) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        Entity entity = this.getOwner();
        return entity == null || ((CompanionsProjectileAccessor)((Object)this)).getLeftOwner() || !entity.isPassengerOfSameVehicle(pTarget);
    }

    @Override
    public void tick() {
        Vec3 v;
        super.tick();
        if (!this.level().isClientSide && this.target != null && this.target.isAlive()) {
            v = this.target.getEyePosition().subtract(this.position()).normalize().scale((double)SPEED);
            this.setDeltaMovement(this.getDeltaMovement().lerp(v, 0.095).normalize().scale((double)SPEED));
            this.hasImpulse = true;
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            v = this.getDeltaMovement();
            this.setYRot((float)(Mth.atan2((double)v.x, (double)v.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)v.y, (double)v.horizontalDistance()) * 57.2957763671875));
        }
        if (this.tickCount % 8 == 0) {
            this.level().addParticle(this.isRed() ? (ParticleOptions)CompanionsParticles.HOLINESS_RED_STAR_TRAIL.get() : (ParticleOptions)CompanionsParticles.HOLINESS_BLUE_STAR_TRAIL.get(), this.getX(), this.getY() - (double)this.getBbHeight() * 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
        if (!this.onGround()) {
            Vec3 pos = this.position();
            Vec3 vec33 = pos.add(this.getDeltaMovement());
            BlockHitResult hitresult = this.level().clip(new ClipContext(pos, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                vec33 = hitresult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(pos, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS) {
                    this.onHit((HitResult)hitresult);
                    this.hasImpulse = true;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            this.checkInsideBlocks();
        }
        if (this.onGround()) {
            this.discard();
        }
        if (this.level().isClientSide && (this.tickCount % 20 == 0 || this.tickCount == 1)) {
            Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), this.isRed() ? 0.8f : 0.09803922f, this.isRed() ? 0.19607843f : 0.54509807f, this.isRed() ? 0.19607843f : 0.3372549f, 0.0f, 0.35f);
        }
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide) {
            if (this.isRed()) {
                this.redExplosion();
            } else {
                this.blueExplosion();
            }
        } else {
            for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
            }
        }
        super.remove(pReason);
    }

    private void redExplosion() {
        RedStarExplosionCenter explosion2;
        RedStarExplosion explosion = (RedStarExplosion)CompanionsEntities.RED_STAR_EXPLOSION.get().create(this.level());
        if (explosion != null) {
            explosion.moveTo(this.position());
            this.level().addFreshEntity((Entity)explosion);
        }
        if ((explosion2 = (RedStarExplosionCenter)CompanionsEntities.RED_STAR_EXPLOSION_CENTER.get().create(this.level())) != null) {
            explosion2.moveTo(this.position());
            this.level().addFreshEntity((Entity)explosion2);
        }
        this.hurtNearby();
    }

    private void blueExplosion() {
        BlueStarExplosionCenter explosion2;
        BlueStarExplosion explosion = (BlueStarExplosion)CompanionsEntities.BLUE_STAR_EXPLOSION.get().create(this.level());
        if (explosion != null) {
            explosion.moveTo(this.position());
            this.level().addFreshEntity((Entity)explosion);
        }
        if ((explosion2 = (BlueStarExplosionCenter)CompanionsEntities.BLUE_STAR_EXPLOSION_CENTER.get().create(this.level())) != null) {
            explosion2.moveTo(this.position());
            this.level().addFreshEntity((Entity)explosion2);
        }
        this.hurtNearby();
    }

    private void hurtNearby() {
        for (LivingEntity e : this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.blockPosition()).inflate(3.0))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this)) continue;
            e.hurt(this.damageSources().magic(), 7.0f);
            if (this.isRed()) {
                e.setRemainingFireTicks(new Random().nextInt(2, 10) * 20);
                continue;
            }
            e.setTicksFrozen(e.getTicksFrozen() + new Random().nextInt(60, 200));
        }
    }

    public boolean isRed() {
        return (Boolean)this.entityData.get(RED);
    }

    public void setRed(boolean isRed) {
        this.entityData.set(RED, (Object)isRed);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        Entity owner = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        entity.hurt(damageSource, (float)CompanionsConfig.HOLINESS_STAR_DAMAGE);
        this.playSound(SoundEvents.DRAGON_FIREBALL_EXPLODE, 5.0f, 1.0f);
        this.remove(Entity.RemovalReason.KILLED);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RED, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Red")) {
            this.setRed(pCompound.getBoolean("Red"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("Red", this.isRed());
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }
}

