/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulMageBookEntity
extends Projectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    private final RawAnimation DEAD = RawAnimation.begin().thenPlay("dead");
    private final RawAnimation SUMMON = RawAnimation.begin().thenPlay("summon");
    private static final EntityDataAccessor<Integer> TARGET_RED = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_GREEN = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_BLUE = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> CURRENT_RED = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CURRENT_GREEN = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CURRENT_BLUE = SynchedEntityData.defineId(SoulMageBookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public SoulMageBookEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (this.getOwner() == null || this.getOwner().isRemoved()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!this.level().isClientSide) {
            this.updateTargetColor();
            this.updateCurrentColor();
        }
        if (this.getOwner() != null) {
            this.orbit(this.getOwner());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TARGET_RED, (Object)255);
        builder.define(TARGET_GREEN, (Object)255);
        builder.define(TARGET_BLUE, (Object)255);
        builder.define(CURRENT_RED, (Object)Float.valueOf(255.0f));
        builder.define(CURRENT_GREEN, (Object)Float.valueOf(255.0f));
        builder.define(CURRENT_BLUE, (Object)Float.valueOf(255.0f));
    }

    public float getCurrentRed() {
        return ((Float)this.entityData.get(CURRENT_RED)).floatValue();
    }

    public float getCurrentGreen() {
        return ((Float)this.entityData.get(CURRENT_GREEN)).floatValue();
    }

    public float getCurrentBlue() {
        return ((Float)this.entityData.get(CURRENT_BLUE)).floatValue();
    }

    public void updateTargetColor() {
        Entity entity = this.getOwner();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity soulMageEntity = (SoulMageEntity)entity;
            int[] color = SoulMageEntity.ATTACK_COLORS.getOrDefault(soulMageEntity.getCurrentAttackType(), SoulMageEntity.ATTACK_COLORS.get("NONE"));
            this.entityData.set(TARGET_RED, (Object)color[0]);
            this.entityData.set(TARGET_GREEN, (Object)color[1]);
            this.entityData.set(TARGET_BLUE, (Object)color[2]);
        } else {
            this.entityData.set(TARGET_RED, (Object)255);
            this.entityData.set(TARGET_GREEN, (Object)255);
            this.entityData.set(TARGET_BLUE, (Object)255);
        }
    }

    public void updateCurrentColor() {
        float curR = ((Float)this.entityData.get(CURRENT_RED)).floatValue();
        float curG = ((Float)this.entityData.get(CURRENT_GREEN)).floatValue();
        float curB = ((Float)this.entityData.get(CURRENT_BLUE)).floatValue();
        int targetR = (Integer)this.entityData.get(TARGET_RED);
        int targetG = (Integer)this.entityData.get(TARGET_GREEN);
        int targetB = (Integer)this.entityData.get(TARGET_BLUE);
        curR = this.lerp(curR, targetR);
        curG = this.lerp(curG, targetG);
        curB = this.lerp(curB, targetB);
        this.entityData.set(CURRENT_RED, (Object)Float.valueOf(curR));
        this.entityData.set(CURRENT_GREEN, (Object)Float.valueOf(curG));
        this.entityData.set(CURRENT_BLUE, (Object)Float.valueOf(curB));
    }

    private float lerp(float start, float target) {
        return start + 0.1f * (target - start);
    }

    private void orbit(Entity owner) {
        double angle = 0.05 * (double)this.level().getGameTime();
        double radius = 2.0;
        Vec3 orbitOffset = new Vec3(radius * Math.cos(angle), 0.0, radius * Math.sin(angle));
        Vec3 targetPos = new Vec3(owner.getX(), owner.getY(), owner.getZ()).add(0.0, (double)owner.getBbHeight(), 0.0).add(orbitOffset);
        Vec3 vel = this.getDeltaMovement();
        double K = 0.006;
        Vec3 accel = targetPos.subtract(this.position()).scale(K).subtract(vel.scale(2.0 * Math.sqrt(K)));
        vel = vel.add(accel);
        this.setDeltaMovement(vel);
        this.move(MoverType.SELF, vel);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("TargetRed", ((Integer)this.entityData.get(TARGET_RED)).intValue());
        pCompound.putInt("TargetGreen", ((Integer)this.entityData.get(TARGET_GREEN)).intValue());
        pCompound.putInt("TargetBlue", ((Integer)this.entityData.get(TARGET_BLUE)).intValue());
        pCompound.putFloat("CurrentRed", ((Float)this.entityData.get(CURRENT_RED)).floatValue());
        pCompound.putFloat("CurrentGreen", ((Float)this.entityData.get(CURRENT_GREEN)).floatValue());
        pCompound.putFloat("CurrentBlue", ((Float)this.entityData.get(CURRENT_BLUE)).floatValue());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("TargetRed")) {
            this.entityData.set(TARGET_RED, (Object)pCompound.getInt("TargetRed"));
            this.entityData.set(TARGET_GREEN, (Object)pCompound.getInt("TargetGreen"));
            this.entityData.set(TARGET_BLUE, (Object)pCompound.getInt("TargetBlue"));
        }
        if (pCompound.contains("CurrentRed")) {
            this.entityData.set(CURRENT_RED, (Object)Float.valueOf(pCompound.getFloat("CurrentRed")));
            this.entityData.set(CURRENT_GREEN, (Object)Float.valueOf(pCompound.getFloat("CurrentGreen")));
            this.entityData.set(CURRENT_BLUE, (Object)Float.valueOf(pCompound.getFloat("CurrentBlue")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackController", 1, this::attackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "sizeController", 1, this::sizePredicate));
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        SoulMageEntity mage;
        Entity entity = this.getOwner();
        if (entity instanceof SoulMageEntity && (mage = (SoulMageEntity)entity).isAttacking() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().setAnimation(this.OPEN);
            event.getController().forceAnimationReset();
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sizePredicate(AnimationState<T> event) {
        Entity entity = this.getOwner();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity mage = (SoulMageEntity)entity;
            if (mage.isDeadOrDying()) {
                event.getController().setAnimation(this.DEAD);
            } else if (this.tickCount < 20) {
                event.getController().setAnimation(this.SUMMON);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

