/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.common.entity.projectile.FloorCakeCreamProjectile;
import dev.xylonity.companions.common.entity.projectile.trigger.GenericTriggerProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CakeCreamTriggerProjectile
extends GenericTriggerProjectile {
    private static final EntityDataAccessor<String> ARMOR_NAME = SynchedEntityData.defineId(CakeCreamTriggerProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public CakeCreamTriggerProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.onGround()) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x * 0.98, motion.y - (double)0.015f, motion.z * 0.98);
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            FloorCakeCreamProjectile cream = (FloorCakeCreamProjectile)CompanionsEntities.FLOOR_CAKE_CREAM.get().create(this.level());
            if (cream != null) {
                cream.moveTo(this.getX(), this.getY(), this.getZ());
                cream.setArmorName(this.getArmorName());
                if (this.getOwner() != null) {
                    cream.setOwner(this.getOwner());
                }
                this.level().addFreshEntity((Entity)cream);
            }
            this.discard();
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ARMOR_NAME, (Object)"default");
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("ArmorName")) {
            this.setArmorName(pCompound.getString("ArmorName"));
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("ArmorName", this.getArmorName());
    }

    public void setArmorName(String name) {
        this.entityData.set(ARMOR_NAME, (Object)name);
    }

    public String getArmorName() {
        return (String)this.entityData.get(ARMOR_NAME);
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
    }
}

