/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.companion.MankhEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LaserTriggerProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(LaserTriggerProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public LivingEntity target;

    public LaserTriggerProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        this.entityData.set(TARGET_ID, (Object)target.getId());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_ID, (Object)-1);
    }

    public int getTargetId() {
        return (Integer)this.entityData.get(TARGET_ID);
    }

    @Override
    protected int baseLifetime() {
        return 60;
    }

    @Override
    public void tick() {
        super.tick();
        Entity entity = this.getOwner();
        if (entity instanceof MankhEntity) {
            MankhEntity mankh = (MankhEntity)entity;
            if (this.target == null && !this.level().isClientSide) {
                int id = (Integer)this.entityData.get(TARGET_ID);
                Entity e2 = this.level().getEntity(id);
                if (e2 instanceof LivingEntity) {
                    this.target = (LivingEntity)e2;
                }
            }
            if (this.target != null) {
                Vec3 mankhPos = mankh.getEyePosition();
                Vec3 targetPos = this.target.getEyePosition();
                Vec3 directionToTarget = targetPos.subtract(mankhPos).normalize();
                double dx = directionToTarget.x;
                double dy = directionToTarget.y;
                double dz = directionToTarget.z;
                float yaw = (float)(Math.atan2(-dx, dz) * 180.0 / Math.PI);
                float pitch = (float)(Math.asin(-dy) * 180.0 / Math.PI);
                mankh.setYRot(yaw);
                mankh.setXRot(pitch);
                Vec3 alpha = mankh.position().add(0.0, (double)mankh.getBbHeight() * 0.5, 0.0).add(directionToTarget.scale(0.05));
                this.moveTo(alpha.x, alpha.y, alpha.z);
                this.setYRot(yaw);
                this.setXRot(pitch);
            }
        }
        if (!this.level().isClientSide && this.target != null) {
            Vec3 start = this.position();
            Vec3 targetPos = this.target.getEyePosition();
            BlockHitResult hit = this.level().clip(new ClipContext(start, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 end = hit.getType() == HitResult.Type.BLOCK && !this.level().getBlockState(hit.getBlockPos()).getCollisionShape((BlockGetter)this.level(), hit.getBlockPos()).isEmpty() ? hit.getLocation() : targetPos;
            AABB bb = new AABB(start, end).inflate(0.25);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, bb, e -> !Util.areEntitiesLinked((Entity)this, (Entity)e));
            for (LivingEntity e3 : entities) {
                Entity entity2 = this.getOwner();
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity2;
                le.doHurtTarget((Entity)e3);
                e3.setDeltaMovement(e3.getDeltaMovement().multiply(0.05, 0.5, 0.05));
            }
        }
        if (this.level().isClientSide) {
            Companions.PROXY.tickLaserTriggerProjectile(this);
        }
    }

    public void spawnSparks(Level level) {
        double y = this.position().y + (double)(this.getBbHeight() * 0.5f);
        for (int i = 0; i < 360; i += 120) {
            double angleRadians = Math.toRadians(i);
            double x = this.position().x + 0.35 * Math.cos(angleRadians);
            double z = this.position().z + 0.35 * Math.sin(angleRadians);
            level.addParticle((ParticleOptions)CompanionsParticles.LASER_SPARK.get(), x, y, z, 0.0, 0.15, 0.0);
        }
    }
}

