/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class LivingCandleEntity
extends CompanionSummonEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public LivingCandleEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new MoveControl((Mob)this);
        this.tickCount = this.getRandom().nextInt(6);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        return this.getOwnerUUID() == null ? null : (LivingEntity)CompanionsEntityTracker.getEntityByUUID(this.getOwnerUUID());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 2.0f, 50.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isTame() && this.getOwner() != null)) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            this.findNearestSoulMage(serverLevel);
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            this.spawnDeadParticles();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    private void spawnDeadParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0 * 0.2;
            double dy = (this.random.nextDouble() - 0.5) * 2.0 * 0.2;
            double dz = (this.random.nextDouble() - 0.5) * 2.0 * 0.2;
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), dx * 1.05, dy * 1.05, dz * 1.05);
            if (i % 5 != 0) continue;
            this.level().addParticle((ParticleOptions)CompanionsParticles.GOLDEN_ALLAY_TRAIL.get(), this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), dx, dy, dz);
        }
    }

    public void doKill() {
        if (this.level().isClientSide) {
            this.spawnDeadParticles();
        } else {
            this.level().playSound(null, this.blockPosition(), SoundEvents.ENDER_EYE_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
        this.discard();
    }

    private void findNearestSoulMage(ServerLevel serverLevel) {
        List nearbyMages = serverLevel.getEntitiesOfClass(SoulMageEntity.class, this.getBoundingBox().inflate(20.0), EntitySelector.NO_SPECTATORS);
        if (!nearbyMages.isEmpty()) {
            SoulMageEntity closestMage = (SoulMageEntity)((Object)nearbyMages.get(0));
            double closestDistance = this.distanceToSqr((Entity)closestMage);
            for (int i = 1; i < nearbyMages.size(); ++i) {
                SoulMageEntity mage = (SoulMageEntity)((Object)nearbyMages.get(i));
                double distance = this.distanceToSqr((Entity)mage);
                if (!(distance < closestDistance)) continue;
                closestMage = mage;
                closestDistance = distance;
            }
            if (closestMage.getCandleCount() < 6) {
                this.setOwnerUUID(closestMage.getUUID());
                closestMage.setCandleCount(closestMage.getCandleCount() + 1);
                closestMage.candles.add(this);
                this.setTame(true, false);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

