/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.event;

import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="companions", bus=EventBusSubscriber.Bus.GAME)
public class CompanionsEntityRespawnTracker {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Player owner;
        TamableAnimal tame;
        UUID ownerId;
        LivingEntity dead = event.getEntity();
        CompoundTag originalTag = dead.getPersistentData();
        if (!originalTag.contains("RespawnTotemPos")) {
            return;
        }
        if (!originalTag.contains("RespawnTotemDim")) {
            return;
        }
        BlockPos pos = BlockPos.of((long)originalTag.getLong("RespawnTotemPos"));
        String dimId = originalTag.getString("RespawnTotemDim");
        MinecraftServer mcServer = dead.level().getServer();
        if (mcServer == null) {
            return;
        }
        ServerLevel totemLevel = mcServer.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimId)));
        if (totemLevel == null) {
            return;
        }
        BlockEntity blockEntity = totemLevel.getBlockEntity(pos);
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return;
        }
        RespawnTotemBlockEntity totem = (RespawnTotemBlockEntity)blockEntity;
        if (totem.getCharges() <= 0) {
            totem.savedEntities.remove(dead.getUUID());
            totem.setChanged();
            return;
        }
        CompoundTag nbt = new CompoundTag();
        dead.save(nbt);
        nbt.remove("DeathTime");
        nbt.remove("HurtByTimestamp");
        nbt.remove("HurtTime");
        nbt.remove("FallFlying");
        nbt.remove("Motion");
        nbt.putFloat("Health", 1.0f);
        totem.queueRespawn(nbt, 20);
        totem.setChanged();
        if (dead instanceof TamableAnimal && (ownerId = (tame = (TamableAnimal)dead).getOwnerUUID()) != null && (owner = totemLevel.getPlayerByUUID(ownerId)) != null) {
            owner.sendSystemMessage((Component)Component.translatable((String)"respawn_totem.companions.charges_remaining", (Object[])new Object[]{pos.toShortString(), totem.getCharges()}));
        }
    }
}

