/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicRelayBlockEntity;
import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrenchItem
extends TooltipItem {
    @Nullable
    private TeslaConnectionManager.ConnectionNode firstNode = null;
    private final int maxConnDist = CompanionsConfig.DINAMO_MAX_CONNECTION_DISTANCE * CompanionsConfig.DINAMO_MAX_CONNECTION_DISTANCE;

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "wrench";
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        DinamoEntity dinamoEntity;
        block6: {
            block5: {
                if (!(target instanceof DinamoEntity)) break block5;
                dinamoEntity = (DinamoEntity)target;
                if (!player.level().isClientSide()) break block6;
            }
            return InteractionResult.PASS;
        }
        if (dinamoEntity.getOwner() != null && !player.equals((Object)dinamoEntity.getOwner())) {
            return InteractionResult.PASS;
        }
        if (dinamoEntity.getMainAction() == 0) {
            this.handleNodeSelection(player, TeslaConnectionManager.ConnectionNode.forEntity(target.getUUID(), player.level().dimension().location()), null);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        BlockEntity be = context.getLevel().getBlockEntity(pos);
        if (be instanceof AbstractTeslaBlockEntity) {
            TeslaConnectionManager.ConnectionNode node = TeslaConnectionManager.ConnectionNode.forBlock(pos, context.getLevel().dimension().location());
            this.handleNodeSelection(context.getPlayer(), node, context);
        }
        return InteractionResult.SUCCESS;
    }

    private void handleNodeSelection(Player player, TeslaConnectionManager.ConnectionNode currentNode, @Nullable UseOnContext context) {
        if (this.firstNode == null) {
            VoltaicPillarBlockEntity be;
            BlockEntity blockEntity;
            if (currentNode.isBlock() && (blockEntity = player.level().getBlockEntity(currentNode.blockPos())) instanceof VoltaicPillarBlockEntity && !(be = (VoltaicPillarBlockEntity)blockEntity).isTop()) {
                player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_non_top_voltaic_pillar").withStyle(ChatFormatting.RED), true);
                return;
            }
            this.firstNode = currentNode;
            this.handleFirstNodeMessage(player, currentNode, context);
        } else {
            boolean anyConnection;
            if (this.firstNode.equals(currentNode)) {
                player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.same_node").withStyle(ChatFormatting.RED), true);
                this.firstNode = null;
                return;
            }
            TeslaConnectionManager manager = TeslaConnectionManager.getInstance();
            boolean connectionAtoB = manager.getOutgoing(this.firstNode).contains(currentNode);
            boolean connectionBtoA = manager.getOutgoing(currentNode).contains(this.firstNode);
            boolean bl = anyConnection = connectionAtoB || connectionBtoA;
            if (anyConnection) {
                if (context == null) {
                    if (connectionAtoB) {
                        manager.removeConnection(this.firstNode, currentNode);
                    } else {
                        manager.removeConnection(currentNode, this.firstNode);
                    }
                } else if (this.firstNode.isEntity()) {
                    manager.removeConnection(this.firstNode, currentNode);
                } else {
                    BlockEntity first = context.getLevel().getBlockEntity(this.firstNode.blockPos());
                    if (first instanceof AbstractTeslaBlockEntity) {
                        AbstractTeslaBlockEntity be = (AbstractTeslaBlockEntity)first;
                        if (connectionAtoB) {
                            be.handleNodeRemoval(this.firstNode, currentNode, context, player);
                        } else {
                            be.handleNodeRemoval(currentNode, this.firstNode, context, player);
                        }
                        be.setOwnerUUID(player.getUUID());
                    }
                }
                player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_deleted").withStyle(ChatFormatting.RED), true);
            } else {
                Vec3 posFirst = this.getNodePosition(this.firstNode);
                Vec3 posCurrent = this.getNodePosition(currentNode);
                if (posFirst == null) {
                    return;
                }
                if (posCurrent == null) {
                    return;
                }
                if (posFirst.distanceToSqr(posCurrent) > (double)this.maxConnDist) {
                    player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_distance", (Object[])new Object[]{CompanionsConfig.DINAMO_MAX_CONNECTION_DISTANCE}).withStyle(ChatFormatting.RED), true);
                    this.firstNode = null;
                    return;
                }
                boolean msgFlag = false;
                if (context == null) {
                    manager.addConnection(this.firstNode, currentNode, false);
                } else {
                    BlockEntity currentBe;
                    if (this.firstNode.isEntity()) {
                        Entity entity = CompanionsEntityTracker.getEntityByUUID(this.firstNode.entityId());
                        if (entity instanceof DinamoEntity) {
                            DinamoEntity dinamo = (DinamoEntity)entity;
                            dinamo.handleNodeSelection(this.firstNode, currentNode);
                            msgFlag = true;
                        }
                    } else {
                        BlockEntity first = context.getLevel().getBlockEntity(this.firstNode.blockPos());
                        if (first instanceof AbstractTeslaBlockEntity) {
                            AbstractTeslaBlockEntity be = (AbstractTeslaBlockEntity)first;
                            if (currentNode.isBlock()) {
                                VoltaicPillarBlockEntity pillar;
                                BlockEntity curr = context.getLevel().getBlockEntity(currentNode.blockPos());
                                if (curr instanceof VoltaicPillarBlockEntity && !(pillar = (VoltaicPillarBlockEntity)curr).isTop()) {
                                    player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_non_top_voltaic_pillar").withStyle(ChatFormatting.RED), true);
                                    this.firstNode = null;
                                    return;
                                }
                                if (first instanceof VoltaicPillarBlockEntity && !(curr instanceof VoltaicPillarBlockEntity)) {
                                    player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_non_voltaic_pillar").withStyle(ChatFormatting.RED), true);
                                    this.firstNode = null;
                                    return;
                                }
                                if (be.getDistance() == CompanionsConfig.DINAMO_MAX_CHAIN_CONNECTIONS && !(curr instanceof VoltaicRelayBlockEntity)) {
                                    player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.max_chain_connections").withStyle(ChatFormatting.RED), true);
                                    this.firstNode = null;
                                    return;
                                }
                            }
                            msgFlag = be.handleNodeSelection(this.firstNode, currentNode, context, player);
                            be.setOwnerUUID(player.getUUID());
                        }
                    }
                    if (currentNode.isBlock() && (currentBe = context.getLevel().getBlockEntity(currentNode.blockPos())) instanceof AbstractTeslaBlockEntity) {
                        AbstractTeslaBlockEntity currentTeslaBe = (AbstractTeslaBlockEntity)currentBe;
                        currentTeslaBe.setOwnerUUID(player.getUUID());
                    }
                }
                if (msgFlag) {
                    player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.connection_established").withStyle(ChatFormatting.GREEN), true);
                }
            }
            if (context != null) {
                context.getLevel().playSound(null, context.getClickedPos(), CompanionsSounds.WRENCH_CONNECTION.get(), SoundSource.BLOCKS, 0.35f, 1.0f);
            }
            this.firstNode = null;
        }
    }

    private void handleFirstNodeMessage(Player player, TeslaConnectionManager.ConnectionNode currentNode, @Nullable UseOnContext context) {
        if (this.firstNode != null) {
            String name = "";
            if (this.firstNode.isEntity()) {
                Entity entity = CompanionsEntityTracker.getEntityByUUID(this.firstNode.entityId());
                if (entity instanceof DinamoEntity) {
                    DinamoEntity dinamo = (DinamoEntity)entity;
                    name = dinamo.getName().getString();
                }
                player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.first_node_selection_entity", (Object[])new Object[]{name}).withStyle(ChatFormatting.GREEN), true);
            } else {
                BlockEntity blockEntity = player.level().getBlockEntity(currentNode.blockPos());
                if (blockEntity instanceof AbstractTeslaBlockEntity) {
                    AbstractTeslaBlockEntity be = (AbstractTeslaBlockEntity)blockEntity;
                    name = new ItemStack((ItemLike)be.getBlockState().getBlock()).getHoverName().getString();
                }
                player.displayClientMessage((Component)Component.translatable((String)"wrench.companions.client_message.first_node_selection_block", (Object[])new Object[]{name}).withStyle(ChatFormatting.GREEN), true);
            }
        }
    }

    @Nullable
    private Vec3 getNodePosition(TeslaConnectionManager.ConnectionNode node) {
        if (node.isEntity()) {
            Entity e = CompanionsEntityTracker.getEntityByUUID(node.entityId());
            return e != null ? e.position() : null;
        }
        BlockPos p = node.blockPos();
        return new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ());
    }
}

