/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.FireMarkRingProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FireMarkBook
extends AbstractMagicBook {
    public FireMarkBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "fire_mark_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        FireMarkRingProjectile fireMarkRing;
        FireMarkRingProjectile fireMarkRing2;
        BlockPos targetPos;
        double distance;
        Vec3 lookVec;
        Vec3 endPos;
        int dist = 50;
        boolean spawnFlag = false;
        Vec3 eyePos = pPlayer.getEyePosition();
        BlockHitResult hit = pLevel.clip(new ClipContext(eyePos, endPos = eyePos.add((lookVec = pPlayer.getLookAngle()).scale((double)dist)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)pPlayer));
        if (hit.getType() == HitResult.Type.BLOCK && (distance = eyePos.distanceTo(Vec3.atCenterOf((Vec3i)(targetPos = hit.getBlockPos())))) <= (double)dist && (fireMarkRing2 = (FireMarkRingProjectile)CompanionsEntities.FIRE_MARK_RING_PROJECTILE.get().create(pLevel)) != null) {
            fireMarkRing2.moveTo((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 1.0, (double)targetPos.getZ() + 0.5);
            fireMarkRing2.setOwner((Entity)pPlayer);
            pLevel.addFreshEntity((Entity)fireMarkRing2);
            spawnFlag = true;
        }
        if (!spawnFlag && (fireMarkRing = (FireMarkRingProjectile)CompanionsEntities.FIRE_MARK_RING_PROJECTILE.get().create(pLevel)) != null) {
            fireMarkRing.moveTo(pPlayer.getX(), pPlayer.getY(), pPlayer.getZ());
            fireMarkRing.setOwner((Entity)pPlayer);
            pLevel.addFreshEntity((Entity)fireMarkRing);
        }
        if (!pLevel.isClientSide) {
            pPlayer.getCooldowns().addCooldown((Item)this, (int)((double)CompanionsConfig.FIRE_MARK_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(pPlayer, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), CompanionsSounds.SPELL_RELEASE_MARK.get(), player.getSoundSource(), 1.0f, 1.0f);
    }
}

