/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.weapon;

import dev.xylonity.companions.common.item.generic.GenericGeckoPickaxeItem;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class BloodScytheItem
extends GenericGeckoPickaxeItem {
    public BloodScytheItem(Item.Properties properties, String resourceKey, ItemMaterials material) {
        super(properties, resourceKey, material);
    }

    public boolean hurtEnemy(@NotNull ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        float healthBefore = pTarget.getHealth();
        boolean toRet = super.hurtEnemy(pStack, pTarget, pAttacker);
        pAttacker.heal((healthBefore - pTarget.getHealth()) * (float)CompanionsConfig.CRYSTALLIZED_BLOOD_SCYTHE_LIFE_STEAL);
        return toRet;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag flag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.icon.companions.star").append((Component)Component.translatable((String)"tooltip.item.companions.key.blood_weapon").withStyle(ChatFormatting.YELLOW)));
        pTooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.item.companions.key.abilities").withStyle(ChatFormatting.DARK_GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_scythe").withStyle(ChatFormatting.WHITE)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_scythe_desc", (Object[])new Object[]{(int)(CompanionsConfig.CRYSTALLIZED_BLOOD_SCYTHE_LIFE_STEAL * 100.0)}).withStyle(ChatFormatting.RED)));
        super.appendHoverText(stack, context, pTooltipComponents, flag);
    }
}

