/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class BlackHoleStarParticle
extends TextureSheetParticle {
    private final SpriteSet spritesset;
    private double angle;
    private double radius;

    BlackHoleStarParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z, 0.0, 0.0, 0.0);
        this.quadSize = 0.15f;
        this.lifetime = new Random().nextInt(0, 15) + 20;
        this.setSpriteFromAge(sprites);
        this.spritesset = sprites;
        this.angle = this.random.nextDouble() * 2.0 * Math.PI;
        this.radius = this.random.nextDouble() * 0.5;
        this.y += this.random.nextDouble() - 0.5;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spritesset);
        this.angle += 0.3;
        this.radius += 8.0E-4;
        this.x = this.xo + this.radius * Math.cos(this.angle) + (this.random.nextDouble() - 0.5) * 0.1;
        this.z = this.zo + this.radius * Math.sin(this.angle) + (this.random.nextDouble() - 0.5) * 0.1;
        this.y = this.yo;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new BlackHoleStarParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

