/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaUtil;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DefaultAttackBehaviour
implements ITeslaNodeBehaviour {
    @Override
    public void process(AbstractTeslaBlockEntity module, Level level, BlockPos blockPos, BlockState blockState) {
        if (module.isActive()) {
            for (TeslaConnectionManager.ConnectionNode connectionNode : TeslaConnectionManager.getInstance().getOutgoing(module.asConnectionNode())) {
                if (connectionNode.isEntity()) {
                    Entity connectedEntity = CompanionsEntityTracker.getEntityByUUID(connectionNode.entityId());
                    if (connectedEntity == null) continue;
                    Vec3 start = module.getBlockPos().getCenter();
                    Vec3 end = connectedEntity.position().add(0.0, (double)connectedEntity.getBbHeight() * 0.5, 0.0);
                    List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(start, end).inflate(1.0));
                    this.hurtNearLine(module, level, entities, start, end);
                    continue;
                }
                if (!connectionNode.isBlock()) continue;
                Vec3 start = module.getBlockPos().getCenter();
                Vec3 end = connectionNode.blockPos().getCenter();
                List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(start, end).inflate(1.0));
                this.hurtNearLine(module, level, entities, start, end);
            }
        }
    }

    private void hurtNearLine(AbstractTeslaBlockEntity module, Level level, List<LivingEntity> entitiesToHurt, Vec3 origin, Vec3 end) {
        for (LivingEntity victim : entitiesToHurt) {
            if (!ITeslaUtil.isEntityNearLine(origin, end, (Entity)victim, 0.75) || !(level instanceof ServerLevel)) continue;
            ServerLevel sv = (ServerLevel)level;
            if (module.getOwnerUUID() == null || Util.areEntitiesLinked(sv.getEntity(module.getOwnerUUID()), (Entity)victim)) continue;
            victim.hurt(victim.level().damageSources().lightningBolt(), (float)CompanionsConfig.ELECTRICITY_DAMAGE);
            victim.addEffect(new MobEffectInstance(CompanionsEffects.ELECTROSHOCK, 50, 0, false, true, true));
        }
    }
}

