/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.tesla.behaviour.dinamo;

import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;

public class DinamoAttackBehaviour
implements ITeslaGeneratorBehaviour {
    @Override
    public void tick(DinamoEntity dinamo) {
        if (dinamo.getAttackCycleCounter() == 0) {
            this.searchForTargets(dinamo);
        }
        if (dinamo.getAttackCycleCounter() < 8) {
            dinamo.setAnimationStartTick(dinamo.getAttackCycleCounter());
            dinamo.setActiveForAttack(true);
        } else if (dinamo.getAttackCycleCounter() == 8) {
            dinamo.setActiveForAttack(false);
            dinamo.setAnimationStartTick(0);
        }
        if (dinamo.isActiveForAttack() && !dinamo.entitiesToAttack.isEmpty()) {
            if (dinamo.level().isClientSide()) {
                double radius = 0.42;
                double initialY = dinamo.position().y + (double)dinamo.getBbHeight() - 0.6;
                for (int i = 0; i < 360; i += 120) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = dinamo.position().x + radius * Math.cos(angleRadians);
                    double particleZ = dinamo.position().z + radius * Math.sin(angleRadians);
                    dinamo.level().addParticle((ParticleOptions)CompanionsParticles.DINAMO_SPARK.get(), particleX, initialY, particleZ, 0.0, 0.35, 0.0);
                }
            }
            if (dinamo.getAttackCycleCounter() == 3) {
                for (LivingEntity target : dinamo.entitiesToAttack) {
                    if (!(target.distanceToSqr((Entity)target) <= 64.0)) continue;
                    target.hurt(dinamo.damageSources().lightningBolt(), (float)CompanionsConfig.ELECTRICITY_DAMAGE);
                    if (!(target.getRandom().nextFloat() < 0.4f)) continue;
                    target.addEffect(new MobEffectInstance(CompanionsEffects.ELECTROSHOCK, 50, 0, false, true, true));
                }
            }
            if (dinamo.getAttackCycleCounter() == 0) {
                dinamo.playSound(CompanionsSounds.DINAMO_ATTACK.get(), 0.45f, 1.0f);
            }
        }
        if (dinamo.getAttackCycleCounter() >= 60) {
            dinamo.setAttackCycleCounter(0);
            dinamo.entitiesToAttack.clear();
            dinamo.setTargetIds("");
            return;
        }
        dinamo.setAttackCycleCounter(dinamo.getAttackCycleCounter() + 1);
    }

    private void searchForTargets(DinamoEntity dinamo) {
        List list = dinamo.level().getEntitiesOfClass(LivingEntity.class, dinamo.getBoundingBox().inflate(10.0), e -> {
            if (Util.areEntitiesLinked((Entity)e, (Entity)dinamo)) {
                return false;
            }
            return e instanceof Monster;
        }).stream().filter(arg_0 -> ((DinamoEntity)dinamo).hasLineOfSight(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        for (LivingEntity m : list) {
            if (dinamo.entitiesToAttack.contains(m)) continue;
            dinamo.entitiesToAttack.add(m);
            dinamo.setTargetIds(dinamo.getTargetIds() + m.getId() + ";");
        }
        if (dinamo.getTarget() != null) {
            dinamo.entitiesToAttack.add(dinamo.getTarget());
            dinamo.setTargetIds(dinamo.getTargetIds() + dinamo.getTarget().getId() + ";");
        }
    }
}

