/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.loot;

import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="companions")
public class CompanionsLootTables {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Item coin;
        UniformGenerator count;
        float chance;
        ResourceLocation id = event.getName();
        if (!"minecraft".equals(id.getNamespace()) || !id.getPath().startsWith("chests/")) {
            return;
        }
        String path = id.getPath();
        if (path.contains("nether")) {
            chance = 0.45f;
            count = UniformGenerator.between((float)1.0f, (float)3.0f);
            coin = CompanionsBlocks.NETHER_COIN.get().asItem();
        } else if (path.contains("end")) {
            chance = 0.8f;
            count = ConstantValue.exactly((float)1.0f);
            coin = CompanionsBlocks.END_COIN.get().asItem();
        } else {
            chance = 0.075f;
            count = UniformGenerator.between((float)1.0f, (float)5.0f);
            coin = CompanionsBlocks.COPPER_COIN.get().asItem();
        }
        LootPool.Builder pool = LootPool.lootPool().name("coin_pool").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)coin).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)count)).when(LootItemRandomChanceCondition.randomChance((float)chance))).add(LootItem.lootTableItem((ItemLike)((ItemLike)CompanionsItems.BOOK_BLACK_HOLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.045f))).add(LootItem.lootTableItem((ItemLike)((ItemLike)CompanionsItems.BOOK_MAGIC_RAY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.045f)));
        event.getTable().addPool(pool.build());
    }
}

