/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.mixin;

import dev.xylonity.companions.common.entity.projectile.PontiffFireRingProjectile;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Player.class})
public class PlayerMixin {
    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true, index=2)
    private float companions$hurt(float dmg, DamageSource pSource, float pAmount) {
        float reduction;
        Player self = (Player)this;
        dmg = pAmount;
        int amountHoly = Util.hasFullSetOn(self, ArmorMaterials.HOLY_ROBE);
        int amountMage = Util.hasFullSetOn(self, ArmorMaterials.MAGE);
        int amountBlood = Util.hasFullSetOn(self, ArmorMaterials.CRYSTALLIZED_BLOOD);
        if (amountBlood != 0 && (double)self.getHealth() <= (double)self.getMaxHealth() * CompanionsConfig.CRYSTALLIZED_BLOOD_SET_MIN_HEALTH) {
            reduction = (float)CompanionsConfig.CRYSTALLIZED_BLOOD_SET_REDUCTION * (float)amountBlood;
            dmg = this.companions$applyRedution(dmg, reduction);
        }
        if (amountMage != 0 && pSource.is(DamageTypes.MAGIC)) {
            reduction = (float)CompanionsConfig.MAGE_SET_DAMAGE_REDUCTION * (float)amountMage;
            dmg = this.companions$applyRedution(dmg, reduction);
        }
        if (amountHoly != 0) {
            PontiffFireRingProjectile ring;
            reduction = (float)CompanionsConfig.HOLY_ROBE_DAMAGE_REDUCTION * (float)amountHoly;
            dmg = this.companions$applyRedution(dmg, reduction);
            if ((double)self.getRandom().nextFloat() <= CompanionsConfig.HOLY_ROBE_FIRE_RING_SPAWN_CHANCE * (double)amountHoly && !self.level().isClientSide && (pSource.getEntity() != null || pSource.is(DamageTypes.EXPLOSION)) && (ring = (PontiffFireRingProjectile)CompanionsEntities.PONTIFF_FIRE_RING.get().create(self.level())) != null) {
                ring.moveTo(self.position());
                ring.setOwner((Entity)self);
                self.level().addFreshEntity((Entity)ring);
            }
        }
        return dmg;
    }

    private float companions$applyRedution(float amount, float reduction) {
        return amount * (1.0f - reduction);
    }
}

