/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.registry;

import dev.xylonity.companions.CompanionsCommon;
import dev.xylonity.companions.common.item.AntlionFur;
import dev.xylonity.companions.common.item.CroissantDragonArmor;
import dev.xylonity.companions.common.item.EternalLighter;
import dev.xylonity.companions.common.item.MutantFlesh;
import dev.xylonity.companions.common.item.PuppetArm;
import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class CompanionsItems {
    public static final Supplier<Item> NETHERITE_CHAINS = CompanionsItems.registerItem("netherite_chains", () -> new TooltipItem(new Item.Properties(), "netherite_chains"));
    public static final Supplier<Item> BIG_BREAD = CompanionsItems.registerItem("big_bread", () -> new TooltipItem(new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().nutrition(10).saturationModifier(0.6f).build()), "big_bread"));
    public static final Supplier<Item> SOUL_GEM = CompanionsItems.registerItem("soul_gem", () -> new TooltipItem(new Item.Properties(), "soul_gem"));
    public static final Supplier<Item> CANNON_ARM = CompanionsItems.registerItem("cannon_arm", () -> new PuppetArm(new Item.Properties().stacksTo(1), "cannon_arm"));
    public static final Supplier<Item> WHIP_ARM = CompanionsItems.registerItem("whip_arm", () -> new PuppetArm(new Item.Properties().stacksTo(1), "whip_arm"));
    public static final Supplier<Item> BLADE_ARM = CompanionsItems.registerItem("blade_arm", () -> new PuppetArm(new Item.Properties().stacksTo(1), "blade_arm"));
    public static final Supplier<Item> MUTANT_ARM = CompanionsItems.registerItem("mutant_arm", () -> new PuppetArm(new Item.Properties().stacksTo(1), "mutant_arm"));
    public static final Supplier<Item> NETHERITE_DAGGER = CompanionsItems.registerItem("netherite_dagger", () -> new SwordItem((Tier)ItemMaterials.NETHERITE_DAGGER, new Item.Properties().fireResistant()));
    public static final Supplier<Item> SAINT_KLIMT_MUSIC_DISC = CompanionsItems.registerMusicDisc("saint_klimt_music_disc", 7, CompanionsSounds.SAINT_KLIMT, new Item.Properties().stacksTo(1), 5800);
    public static final Supplier<Item> MUTANT_FLESH = CompanionsItems.registerItem("mutant_flesh", () -> new MutantFlesh(new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.3f).build()), "mutant_flesh"));
    public static final Supplier<Item> ANTLION_FUR = CompanionsItems.registerItem("antlion_fur", () -> new AntlionFur(new Item.Properties().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.4f).build()), "antlion_fur"));
    public static final Supplier<Item> DEMON_FLESH = CompanionsItems.registerItem("demon_flesh", () -> new TooltipItem(new Item.Properties().food(new FoodProperties.Builder().nutrition(10).saturationModifier(0.6f).build()), "demon_flesh"));
    public static final Supplier<Item> OLD_CLOTH = CompanionsItems.registerItem("old_cloth", () -> new TooltipItem(new Item.Properties().fireResistant(), "old_cloth"));
    public static final Supplier<Item> RELIC_GOLD = CompanionsItems.registerItem("relic_gold", () -> new TooltipItem(new Item.Properties().fireResistant(), "relic_gold"));
    public static final Supplier<Item> CROISSANT_DRAGON_ARMOR_STRAWBERRY = CompanionsItems.registerItem("croissant_dragon_strawberry_armor", () -> new CroissantDragonArmor(new Item.Properties(), "croissant_dragon_strawberry_armor"));
    public static final Supplier<Item> CROISSANT_DRAGON_ARMOR_VANILLA = CompanionsItems.registerItem("croissant_dragon_vanilla_armor", () -> new CroissantDragonArmor(new Item.Properties(), "croissant_dragon_vanilla_armor"));
    public static final Supplier<Item> CROISSANT_DRAGON_ARMOR_CHOCOLATE = CompanionsItems.registerItem("croissant_dragon_chocolate_armor", () -> new CroissantDragonArmor(new Item.Properties(), "croissant_dragon_chocolate_armor"));
    public static final Supplier<Item> BOOK_ICE_SHARD = CompanionsItems.registerMagicBook("book_ice_shard", new Item.Properties().stacksTo(1), MagicType.ICE_SHARD);
    public static final Supplier<Item> BOOK_ICE_TORNADO = CompanionsItems.registerMagicBook("book_ice_tornado", new Item.Properties().stacksTo(1), MagicType.ICE_TORNADO);
    public static final Supplier<Item> BOOK_FIRE_MARK = CompanionsItems.registerMagicBook("book_fire_mark", new Item.Properties().stacksTo(1), MagicType.FIRE_MARK);
    public static final Supplier<Item> BOOK_HEAL_RING = CompanionsItems.registerMagicBook("book_heal_ring", new Item.Properties().stacksTo(1), MagicType.HEAL_RING);
    public static final Supplier<Item> BOOK_STONE_SPIKES = CompanionsItems.registerMagicBook("book_stone_spikes", new Item.Properties().stacksTo(1), MagicType.STONE_SPIKES);
    public static final Supplier<Item> BOOK_BRACE = CompanionsItems.registerMagicBook("book_brace", new Item.Properties().stacksTo(1), MagicType.BRACE);
    public static final Supplier<Item> BOOK_MAGIC_RAY = CompanionsItems.registerMagicBook("book_magic_ray", new Item.Properties().stacksTo(1), MagicType.MAGIC_RAY);
    public static final Supplier<Item> BOOK_BLACK_HOLE = CompanionsItems.registerMagicBook("book_black_hole", new Item.Properties().stacksTo(1), MagicType.BLACK_HOLE);
    public static final Supplier<Item> BOOK_NAGINATA = CompanionsItems.registerMagicBook("book_naginata", new Item.Properties().stacksTo(1), MagicType.NAGINATA);
    public static final Supplier<Item> ETERNAL_LIGHTER = CompanionsItems.registerItem("eternal_lighter", () -> new EternalLighter(new Item.Properties().stacksTo(1).durability(256)));
    public static final Supplier<Item> WRENCH = CompanionsItems.registerSpecificItem("wrench", new Item.Properties().durability(128), ItemType.WRENCH);
    public static final Supplier<Item> HOURGLASS = CompanionsItems.registerSpecificItem("hourglass", new Item.Properties().stacksTo(1).durability(12), ItemType.HOURGLASS);
    public static final Supplier<Item> SHADOW_BELL = CompanionsItems.registerSpecificItem("shadow_bell", new Item.Properties().stacksTo(1).fireResistant(), ItemType.SHADOW_BELL);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD = CompanionsItems.registerSpecificItem("crystallized_blood", new Item.Properties(), ItemType.CRYSTALLIZED_BLOOD);
    public static final Supplier<Item> NEEDLE = CompanionsItems.registerSpecificItem("needle", new Item.Properties(), ItemType.NEEDLE);
    public static final Supplier<Item> MAGE_HAT = CompanionsItems.registerArmorItem("mage_hat", ArmorMaterials.MAGE, ArmorItem.Type.HELMET, true);
    public static final Supplier<Item> MAGE_COAT = CompanionsItems.registerArmorItem("mage_coat", ArmorMaterials.MAGE, ArmorItem.Type.CHESTPLATE, true);
    public static final Supplier<Item> MAGE_LEGGINGS = CompanionsItems.registerArmorItem("mage_leggings", ArmorMaterials.MAGE, ArmorItem.Type.LEGGINGS, true);
    public static final Supplier<Item> MAGE_STAFF = CompanionsItems.registerSpecificItem("mage_staff", new Item.Properties().stacksTo(1), ItemType.GENERIC);
    public static final Supplier<Item> HOLY_ROBE_MASK = CompanionsItems.registerArmorItem("holy_robe_mask", ArmorMaterials.HOLY_ROBE, ArmorItem.Type.HELMET, true);
    public static final Supplier<Item> HOLY_ROBE_COAT = CompanionsItems.registerArmorItem("holy_robe_coat", ArmorMaterials.HOLY_ROBE, ArmorItem.Type.CHESTPLATE, true);
    public static final Supplier<Item> HOLY_ROBE_LEGGINGS = CompanionsItems.registerArmorItem("holy_robe_leggings", ArmorMaterials.HOLY_ROBE, ArmorItem.Type.LEGGINGS, true);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_HELMET = CompanionsItems.registerArmorItem("crystallized_blood_helmet", ArmorMaterials.CRYSTALLIZED_BLOOD, ArmorItem.Type.HELMET, true);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_CHESTPLATE = CompanionsItems.registerArmorItem("crystallized_blood_chestplate", ArmorMaterials.CRYSTALLIZED_BLOOD, ArmorItem.Type.CHESTPLATE, false);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_LEGGINGS = CompanionsItems.registerArmorItem("crystallized_blood_leggings", ArmorMaterials.CRYSTALLIZED_BLOOD, ArmorItem.Type.LEGGINGS, false);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_BOOTS = CompanionsItems.registerArmorItem("crystallized_blood_boots", ArmorMaterials.CRYSTALLIZED_BLOOD, ArmorItem.Type.BOOTS, false);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_SWORD = CompanionsItems.registerSpecificItem("crystallized_blood_sword", new Item.Properties(), ItemType.BLOOD_SWORD, ItemMaterials.CRYSTALLIZED_BLOOD, 3.0f, -2.4f);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_SCYTHE = CompanionsItems.registerSpecificItem("crystallized_blood_scythe", new Item.Properties(), ItemType.BLOOD_PICKAXE, ItemMaterials.CRYSTALLIZED_BLOOD, 1.0f, -2.8f);
    public static final Supplier<Item> CRYSTALLIZED_BLOOD_AXE = CompanionsItems.registerSpecificItem("crystallized_blood_axe", new Item.Properties(), ItemType.BLOOD_AXE, ItemMaterials.CRYSTALLIZED_BLOOD, 5.0f, -3.0f);

    public static void init() {
    }

    private static <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return CompanionsCommon.COMMON_PLATFORM.registerItem(id, item);
    }

    private static <T extends Item> Supplier<T> registerSpecificItem(String id, Item.Properties properties, ItemType itemType) {
        return CompanionsCommon.COMMON_PLATFORM.registerSpecificItem(id, properties, itemType);
    }

    private static <T extends Item> Supplier<T> registerSpecificItem(String id, Item.Properties properties, ItemType itemType, ItemMaterials material, float extraDamage, float extraSpeed) {
        return CompanionsCommon.COMMON_PLATFORM.registerSpecificItem(id, properties, itemType, material, extraDamage, extraSpeed);
    }

    private static <T extends Item> Supplier<T> registerArmorItem(String id, Holder<ArmorMaterial> armorMaterial, ArmorItem.Type armorType, boolean isGeckoArmor) {
        return CompanionsCommon.COMMON_PLATFORM.registerArmorItem(id, armorMaterial, armorType, isGeckoArmor);
    }

    private static <T extends Item> Supplier<T> registerMagicBook(String id, Item.Properties properties, MagicType magicType) {
        return CompanionsCommon.COMMON_PLATFORM.registerMagicBook(id, properties, magicType);
    }

    private static <T extends Item> Supplier<T> registerMusicDisc(String id, int signal, Supplier<SoundEvent> soundEvent, Item.Properties properties, int length) {
        return CompanionsCommon.COMMON_PLATFORM.registerMusicDisc(id, signal, soundEvent, properties, length);
    }

    public static enum ItemType {
        HOURGLASS,
        WRENCH,
        SHADOW_BELL,
        CRYSTALLIZED_BLOOD,
        NEEDLE,
        GENERIC,
        BLOOD_SWORD,
        BLOOD_PICKAXE,
        BLOOD_AXE;

    }

    public static enum MagicType {
        ICE_SHARD,
        ICE_TORNADO,
        FIRE_MARK,
        HEAL_RING,
        STONE_SPIKES,
        BRACE,
        BLACK_HOLE,
        NAGINATA,
        MAGIC_RAY;

    }
}

