/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.registry;

import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.container.PuppetContainerMenu;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import dev.xylonity.companions.common.container.SoulMageContainerMenu;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CompanionsMenuTypes {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"companions");
    public static final Supplier<MenuType<SoulFurnaceContainerMenu>> SOUL_FURNACE = CompanionsMenuTypes.registerMenu("soul_furnace_container_menu", (id, inv, buf) -> {
        BlockPos pos = buf.readBlockPos();
        BlockEntity be = inv.player.level().getBlockEntity(pos);
        if (be instanceof SoulFurnaceBlockEntity) {
            SoulFurnaceBlockEntity furnace = (SoulFurnaceBlockEntity)be;
            return new SoulFurnaceContainerMenu(id, inv, furnace, (ContainerData)new SimpleContainerData(3));
        }
        throw new IllegalStateException(String.valueOf(pos));
    });
    public static final Supplier<MenuType<SoulMageContainerMenu>> SOUL_MAGE_CONTAINER = CompanionsMenuTypes.registerMenu("soul_mage_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.player.level().getEntity(entityId);
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity soulMage = (SoulMageEntity)entity;
            return new SoulMageContainerMenu(id, inv, soulMage);
        }
        throw new IllegalStateException("" + entityId);
    });
    public static final Supplier<MenuType<PuppetContainerMenu>> PUPPET_CONTAINER = CompanionsMenuTypes.registerMenu("puppet_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.player.level().getEntity(entityId);
        if (entity instanceof PuppetEntity) {
            PuppetEntity puppet = (PuppetEntity)entity;
            return new PuppetContainerMenu(id, inv, puppet);
        }
        throw new IllegalStateException("" + entityId);
    });
    public static final Supplier<MenuType<CorneliusContainerMenu>> CORNELIUS_CONTAINER = CompanionsMenuTypes.registerMenu("cornelius_container_menu", (id, inv, buf) -> {
        int entityId = buf.readInt();
        Entity entity = inv.player.level().getEntity(entityId);
        if (entity instanceof CorneliusEntity) {
            CorneliusEntity puppet = (CorneliusEntity)entity;
            return new CorneliusContainerMenu(id, inv, puppet);
        }
        throw new IllegalStateException("" + entityId);
    });

    public static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenu(String name, MenuFactory<T> factory) {
        return MENU_TYPES.register(name, () -> IMenuTypeExtension.create(factory::create));
    }

    @FunctionalInterface
    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, FriendlyByteBuf var3);
    }
}

