/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.arcane;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SpawnerCageBlock
extends Block {
    public static BooleanProperty UP = BooleanProperty.create((String)"up");
    public static BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static BooleanProperty WEST = BooleanProperty.create((String)"west");

    public SpawnerCageBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        return this.getTargetState((LevelAccessor)world, pos);
    }

    private BlockState getTargetState(LevelAccessor world, BlockPos pos) {
        BlockState state = this.defaultBlockState();
        if (world.getBlockState(pos.above()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(true));
        }
        if (world.getBlockState(pos.below()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(true));
        }
        if (world.getBlockState(pos.north()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (world.getBlockState(pos.east()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
        }
        if (world.getBlockState(pos.south()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
        }
        if (world.getBlockState(pos.west()).is(this.asBlock())) {
            state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.getTargetState(world, pos);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.spawner_cage").withStyle(ChatFormatting.GRAY));
    }
}

