/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.processing;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.MachineBlock;
import rearth.oritech.block.blocks.processing.RefineryModuleBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.util.MultiblockMachineController;

public class MachineCoreBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty USED = BooleanProperty.create((String)"core_used");
    private final float coreQuality;

    public MachineCoreBlock(BlockBehaviour.Properties settings, float coreQuality) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)USED, (Comparable)Boolean.valueOf(false)));
        this.coreQuality = coreQuality;
    }

    public float getCoreQuality() {
        return this.coreQuality;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{USED});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.machine_core_block").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        super.appendHoverText(stack, context, tooltip, options);
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)USED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        MachineCoreBlock.onBlockRemoved(state, (LevelAccessor)world, pos);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        MachineCoreBlock.onBlockRemoved(state, (LevelAccessor)level, pos);
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        MachineCoreBlock.onBlockRemoved(state, level, pos);
        super.destroy(level, pos, state);
    }

    protected void onExplosionHit(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        MachineCoreBlock.onBlockRemoved(state, (LevelAccessor)world, pos);
        super.onExplosionHit(state, world, pos, explosion, stackMerger);
    }

    private static void onBlockRemoved(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockEntity blockEntity;
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        BlockEntity blockEntity2;
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)USED)).booleanValue() && (blockEntity2 = world.getBlockEntity(pos)) instanceof MachineCoreEntity && (controllerPos = (coreEntity = (MachineCoreEntity)blockEntity2).getControllerPos()) != null && (blockEntity = world.getBlockEntity(controllerPos)) instanceof MultiblockMachineController) {
            MultiblockMachineController machineEntity = (MultiblockMachineController)blockEntity;
            machineEntity.onCoreBroken(pos);
        }
    }

    @NotNull
    public static BlockPos getControllerPos(LevelAccessor world, BlockPos pos) {
        MachineCoreEntity coreEntity = (MachineCoreEntity)world.getBlockEntity(pos);
        return Objects.requireNonNull(coreEntity).getControllerPos();
    }

    @Nullable
    public static BlockEntity getControllerEntity(LevelAccessor world, BlockPos pos) {
        return world.getBlockEntity(MachineCoreBlock.getControllerPos(world, pos));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)USED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            DeepDrillEntity deepDrill;
            BlockPos controllerPos = MachineCoreBlock.getControllerPos((LevelAccessor)world, pos);
            BlockState controllerBlock = world.getBlockState(controllerPos);
            BlockEntity controllerEntity = world.getBlockEntity(controllerPos);
            if (controllerEntity instanceof DeepDrillEntity && !(deepDrill = (DeepDrillEntity)controllerEntity).init(true)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.deep_drill.ore_placement"));
                return InteractionResult.SUCCESS;
            }
            return controllerBlock.useWithoutItem(world, player, new BlockHitResult(hit.getLocation(), hit.getDirection(), controllerPos, hit.isInside()));
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)USED)).booleanValue()) {
            super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        if (!world.isClientSide) {
            BlockPos controllerPos = MachineCoreBlock.getControllerPos((LevelAccessor)world, pos);
            BlockState controllerBlock = world.getBlockState(controllerPos);
            Block block = controllerBlock.getBlock();
            if (block instanceof MachineBlock) {
                MachineBlock machineBlock = (MachineBlock)block;
                return machineBlock.useItemOn(stack, state, world, pos, player, hand, hit);
            }
            block = controllerBlock.getBlock();
            if (block instanceof RefineryModuleBlock) {
                RefineryModuleBlock machineBlock = (RefineryModuleBlock)block;
                return machineBlock.useItemOn(stack, state, world, pos, player, hand, hit);
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MachineCoreEntity(pos, state);
    }
}

