/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MultiblockMachineController;

public class MachineCoreEntity
extends BlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
FluidApi.BlockProvider {
    private BlockPos controllerPos = BlockPos.ZERO;
    private MultiblockMachineController controllerEntity;
    private final Map<Direction, DelegatingEnergyStorage> delegatedEnergy = new HashMap<Direction, DelegatingEnergyStorage>(6);
    private final Map<Direction, DelegatingFluidStorage> delegatedFluid = new HashMap<Direction, DelegatingFluidStorage>(6);
    private final Map<Direction, DelegatingInventoryStorage> delegatedItem = new HashMap<Direction, DelegatingInventoryStorage>(6);

    public MachineCoreEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.MACHINE_CORE_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("controller_x", this.controllerPos.getX());
        nbt.putInt("controller_y", this.controllerPos.getY());
        nbt.putInt("controller_z", this.controllerPos.getZ());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.controllerPos = new BlockPos(nbt.getInt("controller_x"), nbt.getInt("controller_y"), nbt.getInt("controller_z"));
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerEntity = null;
        this.setChanged();
    }

    @Nullable
    public MultiblockMachineController getCachedController() {
        if (this.level == null || !((Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED)).booleanValue()) {
            return null;
        }
        if (this.controllerEntity == null || ((BlockEntity)this.controllerEntity).isRemoved()) {
            MultiblockMachineController controller;
            BlockEntity candidate = Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
            this.controllerEntity = candidate instanceof MultiblockMachineController ? (controller = (MultiblockMachineController)candidate) : null;
        }
        return this.controllerEntity;
    }

    @Nullable
    private EnergyApi.EnergyStorage getMainEnergyStorage(Direction direction) {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (controllerEntity == null) {
            return new SimpleEnergyStorage(0L, 0L, 0L);
        }
        return controllerEntity.getEnergyStorageForMultiblock(direction);
    }

    private FluidApi.FluidStorage getMainFluidStorage(Direction direction) {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof FluidApi.BlockProvider)) {
            return null;
        }
        FluidApi.BlockProvider fluidProvider = (FluidApi.BlockProvider)((Object)controllerEntity);
        return fluidProvider.getFluidStorage(direction);
    }

    private ItemApi.InventoryStorage getMainItemStorage(Direction direction) {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof ItemApi.BlockProvider)) {
            return null;
        }
        ItemApi.BlockProvider itemProvider = (ItemApi.BlockProvider)((Object)controllerEntity);
        return itemProvider.getInventoryStorage(direction);
    }

    @Nullable
    private EnergyApi.EnergyStorage getEnergyStorageDelegated(Direction direction) {
        return this.delegatedEnergy.computeIfAbsent(direction, dir -> {
            if (this.getMainEnergyStorage((Direction)dir) == null) {
                return null;
            }
            return new DelegatingEnergyStorage(() -> this.getMainEnergyStorage((Direction)dir), this::isEnabled);
        });
    }

    private FluidApi.FluidStorage getFluidStorageDelegated(Direction direction) {
        return this.delegatedFluid.computeIfAbsent(direction, dir -> {
            if (this.getMainFluidStorage((Direction)dir) == null) {
                return null;
            }
            return new DelegatingFluidStorage(() -> this.getMainFluidStorage((Direction)dir), this::isEnabled);
        });
    }

    private ItemApi.InventoryStorage getItemStorageDelegated(Direction direction) {
        return this.delegatedItem.computeIfAbsent(direction, dir -> {
            if (this.getMainItemStorage((Direction)dir) == null) {
                return null;
            }
            return new DelegatingInventoryStorage(() -> this.getMainItemStorage((Direction)dir), this::isEnabled);
        });
    }

    public void resetCaches() {
        this.delegatedItem.clear();
        this.delegatedFluid.clear();
        this.delegatedEnergy.clear();
    }

    public boolean isEnabled() {
        return (Boolean)this.getBlockState().getValue((Property)MachineCoreBlock.USED);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.getEnergyStorageDelegated(direction);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.getItemStorageDelegated(direction);
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(Direction direction) {
        return this.getFluidStorageDelegated(direction);
    }
}

