/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

public class InventoryProxyAddonBlockEntity
extends AddonBlockEntity
implements ItemApi.BlockProvider,
ExtendedMenuProvider {
    private MachineAddonController cachedController;
    private int targetSlot = 0;
    private final DelegatingInventoryStorage inventory = new DelegatingInventoryStorage(this::getTargetItemStorage, this::isConnected){

        @Override
        public int insert(ItemStack inserted, boolean simulate) {
            return this.insertToSlot(inserted, InventoryProxyAddonBlockEntity.this.targetSlot, simulate);
        }

        @Override
        public int extract(ItemStack extracted, boolean simulate) {
            return this.extractFromSlot(extracted, InventoryProxyAddonBlockEntity.this.targetSlot, simulate);
        }

        @Override
        public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
            if (slot != InventoryProxyAddonBlockEntity.this.targetSlot) {
                return 0;
            }
            return super.insertToSlot(inserted, slot, simulate);
        }

        @Override
        public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
            if (slot != InventoryProxyAddonBlockEntity.this.targetSlot) {
                return 0;
            }
            return super.extractFromSlot(extracted, slot, simulate);
        }
    };

    public InventoryProxyAddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.INVENTORY_PROXY_ADDON_ENTITY, pos, state);
    }

    private ItemApi.InventoryStorage getTargetItemStorage() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MachineAddonController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof ItemApi.BlockProvider)) {
            return null;
        }
        ItemApi.BlockProvider itemProvider = (ItemApi.BlockProvider)((Object)controllerEntity);
        return itemProvider.getInventoryStorage(null);
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    private MachineAddonController getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        this.cachedController = (MachineAddonController)Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
        return this.cachedController;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        InventoryProxyScreenHandler.InvProxyData data = new InventoryProxyScreenHandler.InvProxyData(this.worldPosition, this.getControllerPos(), this.targetSlot);
        InventoryProxyScreenHandler.InvProxyData.PACKET_CODEC.encode((Object)buf, (Object)data);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"title.oritech.inventory_proxy");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new InventoryProxyScreenHandler(syncId, playerInventory, this, this.getCachedController().getScreenProvider(), this.targetSlot);
    }

    public void setTargetSlot(int targetSlot) {
        this.targetSlot = targetSlot;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("target_slot", this.targetSlot);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.targetSlot = nbt.getInt("target_slot");
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public static void receiveSlotSelection(InventoryProxySlotSelectorPacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = player.level().getBlockEntity(packet.position);
        if (blockEntity instanceof InventoryProxyAddonBlockEntity) {
            InventoryProxyAddonBlockEntity addonBlock = (InventoryProxyAddonBlockEntity)blockEntity;
            addonBlock.setTargetSlot(packet.slot);
        }
    }

    public record InventoryProxySlotSelectorPacket(BlockPos position, int slot) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<InventoryProxySlotSelectorPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("proxy_slot_sel"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

