/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.arcane.BaseSoulCollectionEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class SpawnerControllerBlockEntity
extends BaseSoulCollectionEntity
implements BlockEntityTicker<SpawnerControllerBlockEntity>,
ComparatorOutputProvider {
    public int maxSouls = 100000;
    public int collectedSouls = 0;
    public CompoundTag mobNbt = new CompoundTag();
    public Entity renderedEntity;
    private boolean networkDirty;
    public boolean hasCage;
    private int lastComparatorOutput;
    private boolean redstonePowered;
    public float lastProgress = 0.0f;

    public SpawnerControllerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.SPAWNER_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, SpawnerControllerBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (this.mobNbt.isEmpty() || !this.hasCage || this.redstonePowered) {
            return;
        }
        if (this.collectedSouls >= this.maxSouls && world.getGameTime() % 4L == 0L) {
            this.spawnMob();
            this.updateComparator();
        }
        if (this.networkDirty) {
            this.updateNetwork();
            BaseSoulCollectionEntity.DeathListener.resetEvents();
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("souls", this.collectedSouls);
        nbt.putInt("maxSouls", this.maxSouls);
        nbt.putBoolean("cage", this.hasCage);
        nbt.putBoolean("redstone", this.redstonePowered);
        if (this.mobNbt != null) {
            nbt.put("mobNbt", (Tag)this.mobNbt);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasCage = nbt.getBoolean("cage");
        this.maxSouls = nbt.getInt("maxSouls");
        this.collectedSouls = nbt.getInt("souls");
        this.redstonePowered = nbt.getBoolean("redstone");
        this.mobNbt = nbt.getCompound("mobNbt");
    }

    private void spawnMob() {
        Entity spawned = EntityType.loadEntityRecursive((CompoundTag)this.mobNbt, (Level)this.level, entity -> {
            int spawnRange = 4;
            int requiredHeight = Math.round(entity.getBbHeight() + 0.5f);
            BlockPos targetPosition = this.findSpawnPosition(spawnRange, requiredHeight);
            if (targetPosition == null) {
                return null;
            }
            entity.moveTo(Vec3.atLowerCornerOf((Vec3i)targetPosition));
            entity.setUUID(UUID.randomUUID());
            ParticleContent.SOUL_USED.spawn(this.level, targetPosition.getCenter(), (Object)this.maxSouls);
            return entity;
        });
        if (spawned == null) {
            return;
        }
        this.networkDirty = true;
        this.level.addFreshEntity(spawned);
        this.collectedSouls -= this.maxSouls;
    }

    private BlockPos findSpawnPosition(int spawnRange, int requiredHeight) {
        for (int i = 0; i < 10; ++i) {
            BlockPos candidate = this.worldPosition.offset(this.level.random.nextIntBetweenInclusive(-spawnRange, spawnRange), 3, this.level.random.nextIntBetweenInclusive(-spawnRange, spawnRange));
            int foundFree = 0;
            for (int j = 0; j < 9; ++j) {
                BlockState state = this.level.getBlockState(candidate.below(j));
                if (state.isAir()) {
                    ++foundFree;
                    continue;
                }
                if (foundFree > requiredHeight) {
                    return candidate.below(j - 1);
                }
                foundFree = 0;
            }
        }
        return null;
    }

    private void updateNetwork() {
        this.networkDirty = false;
        if (!this.mobNbt.isEmpty()) {
            NetworkManager.sendBlockHandle(this, new SpawnerSyncPacket(this.worldPosition, this.mobNbt, this.hasCage, this.collectedSouls, this.maxSouls));
        }
    }

    public static void receiveUpdatePacket(SpawnerSyncPacket message, Level world, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = world.getBlockEntity(message.position);
        if (blockEntity instanceof SpawnerControllerBlockEntity) {
            SpawnerControllerBlockEntity spawnerEntity = (SpawnerControllerBlockEntity)blockEntity;
            spawnerEntity.mobNbt = message.spawnedMob;
            spawnerEntity.hasCage = message.hasCage;
            spawnerEntity.collectedSouls = message.collectedSouls;
            spawnerEntity.maxSouls = message.maxSouls;
            spawnerEntity.loadRendererFromUpdate();
        }
    }

    public void loadRendererFromUpdate() {
        Entity spawned = EntityType.loadEntityRecursive((CompoundTag)this.mobNbt, (Level)this.level, entity -> entity);
        if (spawned == null) {
            return;
        }
        if (this.renderedEntity == null || spawned.getType() != this.renderedEntity.getType()) {
            this.renderedEntity = spawned;
        }
    }

    public void setChanged() {
        super.setChanged();
        this.networkDirty = true;
    }

    @Override
    public boolean canAcceptSoul() {
        return this.collectedSouls < this.maxSouls;
    }

    private void updateComparator() {
        int progress = this.getComparatorOutput();
        if (this.lastComparatorOutput != progress) {
            this.lastComparatorOutput = progress;
            this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    @Override
    public int getComparatorOutput() {
        if (this.mobNbt.isEmpty() || this.maxSouls == 0) {
            return 0;
        }
        return (int)((float)this.collectedSouls / (float)this.maxSouls * 15.0f);
    }

    public void setRedstonePowered(boolean active) {
        this.redstonePowered = active;
    }

    @Override
    public void onSoulIncoming(Vec3 source) {
        float distance = (float)source.distanceTo(this.worldPosition.getCenter());
        ++this.collectedSouls;
        Vec3 soulPath = this.worldPosition.getCenter().subtract(source);
        ParticleContent.SoulParticleData animData = new ParticleContent.SoulParticleData(soulPath, (int)SpawnerControllerBlockEntity.getSoulTravelDuration(distance));
        ParticleContent.WANDERING_SOUL.spawn(this.level, source.add(0.0, (double)0.7f, 0.0), (Object)animData);
        this.networkDirty = true;
        this.updateComparator();
    }

    private int getSoulCost(int maxHp) {
        return (int)(Math.sqrt(maxHp) + 0.5) * Oritech.CONFIG.spawnerCostMultiplier();
    }

    public void onEntitySteppedOn(Entity entity) {
        if (!this.mobNbt.isEmpty()) {
            return;
        }
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            if (mobEntity.getType().arch$holder().is(TagContent.SPAWNER_BLACKLIST)) {
                Oritech.LOGGER.debug("Ignored blacklisted entity for spawner: " + String.valueOf(mobEntity.getType().arch$registryName()));
                return;
            }
            CompoundTag nbt = new CompoundTag();
            mobEntity.save(nbt);
            this.mobNbt = nbt;
            this.networkDirty = true;
            this.maxSouls = this.getSoulCost((int)mobEntity.getMaxHealth());
            mobEntity.remove(Entity.RemovalReason.DISCARDED);
            this.reloadCage(null);
            this.setChanged();
        }
    }

    public void onBlockInteracted(Player player) {
        if (this.mobNbt.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.spawner.no_mob"));
            return;
        }
        this.networkDirty = true;
        this.reloadCage(player);
        if (this.hasCage) {
            player.sendSystemMessage((Component)Component.translatable((String)"tooltip.oritech.spawner.collected_souls", (Object[])new Object[]{this.collectedSouls, this.maxSouls}));
        }
    }

    private void reloadCage(@Nullable Player player) {
        Entity spawned = EntityType.loadEntityRecursive((CompoundTag)this.mobNbt, (Level)this.level, entity -> entity);
        if (spawned == null) {
            return;
        }
        Vec3i cageSize = new Vec3i(Math.round(spawned.getBbWidth() * 2.0f + 0.5f), Math.round(spawned.getBbHeight() + 0.5f), Math.round(spawned.getBbWidth() * 2.0f + 0.5f));
        int offset = cageSize.getX() / 2;
        this.hasCage = true;
        for (int x = 0; x < cageSize.getX(); ++x) {
            for (int y = 0; y < cageSize.getY(); ++y) {
                for (int z = 0; z < cageSize.getZ(); ++z) {
                    BlockPos candidate = this.worldPosition.offset(-offset + x, -y - 1, -offset + z);
                    if (this.level.getBlockState(candidate).getBlock().equals(BlockContent.SPAWNER_CAGE_BLOCK)) continue;
                    this.hasCage = false;
                    ParticleContent.DEBUG_BLOCK.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)candidate));
                }
            }
        }
        if (!this.hasCage && player != null) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.spawner.no_cage"));
        }
        this.setChanged();
    }

    public record SpawnerSyncPacket(BlockPos position, CompoundTag spawnedMob, boolean hasCage, int collectedSouls, int maxSouls) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SpawnerSyncPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("spawner"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

