/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.time.StopWatch;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;

public class ItemPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity {
    private static final int TRANSFER_AMOUNT = Oritech.CONFIG.itemPipeTransferAmount();
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.itemPipeIntervalDuration();
    private List<Tuple<ItemApi.InventoryStorage, BlockPos>> filteredTargetItemStorages;
    private final HashMap<BlockPos, Tuple<ArrayList<BlockPos>, Integer>> cachedTransferPaths = new HashMap();
    private final boolean renderItems;
    private static final HashMap<BlockPos, Long> blockedUntil = new HashMap();
    public Set<RenderStackData> activeStacks = new HashSet<RenderStackData>();

    public ItemPipeInterfaceEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ITEM_PIPE_ENTITY, pos, state);
        this.renderItems = state.getBlock().equals(BlockContent.TRANSPARENT_ITEM_PIPE_CONNECTION);
    }

    public void tick(Level world, BlockPos pos, BlockState state, GenericPipeInterfaceEntity blockEntity) {
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.getBlock();
        if (world.isClientSide || !block.isExtractable(state)) {
            return;
        }
        if ((world.getGameTime() + this.worldPosition.asLong()) % (long)TRANSFER_PERIOD != 0L && !this.isBoostAvailable()) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = ItemPipeBlock.ITEM_PIPE_DATA.getOrDefault(world.dimension().location(), new GenericPipeInterfaceEntity.PipeNetworkData());
        Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
        ItemStack stackToMove = ItemStack.EMPTY;
        ItemApi.InventoryStorage moveFromInventory = null;
        BlockPos takenFrom = null;
        int moveCapacity = this.isBoostAvailable() ? 64 : TRANSFER_AMOUNT;
        Boolean hasMotor = (Boolean)state.getValue((Property)ItemPipeConnectionBlock.HAS_MOTOR);
        block0: for (BlockPos sourcePos : sources) {
            ItemApi.InventoryStorage inventory;
            BlockPos offset;
            Direction direction;
            Long blockedTimer = blockedUntil.getOrDefault(sourcePos, 0L);
            if (world.getGameTime() < blockedTimer) continue;
            if (blockedTimer > 0L) {
                blockedUntil.remove(sourcePos);
            }
            if (!block.isSideExtractable(state, (direction = Direction.fromDelta((int)(offset = pos.subtract((Vec3i)sourcePos)).getX(), (int)offset.getY(), (int)offset.getZ())).getOpposite()) || (inventory = ItemApi.BLOCK.find(world, sourcePos, direction)) == null || !inventory.supportsExtraction()) continue;
            for (int i = 0; i < inventory.getSlotCount(); ++i) {
                int extracted;
                ItemStack slotStack = inventory.getStackInSlot(i);
                if (slotStack.isEmpty()) continue;
                int canTake = inventory.extractFromSlot(slotStack.copyWithCount(moveCapacity), i, true);
                if (canTake > 0) {
                    stackToMove = slotStack.copyWithCount(canTake);
                    moveFromInventory = inventory;
                    takenFrom = sourcePos;
                } else {
                    stackToMove = ItemStack.EMPTY;
                }
                if (stackToMove.isEmpty()) continue;
                Set<Tuple<BlockPos, Direction>> targets = ItemPipeInterfaceEntity.findNetworkTargets(pos, data);
                if (targets == null) {
                    System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.getBlockPos()));
                    return;
                }
                int netHash = targets.hashCode();
                if (netHash != this.filteredTargetsNetHash || this.filteredTargetItemStorages == null) {
                    this.filteredTargetItemStorages = targets.stream().filter(target -> {
                        Direction targetDir = (Direction)target.getB();
                        BlockPos pipePos = ((BlockPos)target.getA()).offset(targetDir.getNormal());
                        BlockState pipeState = world.getBlockState(pipePos);
                        Block patt0$temp = pipeState.getBlock();
                        if (!(patt0$temp instanceof ItemPipeConnectionBlock)) {
                            return true;
                        }
                        ItemPipeConnectionBlock itemBlock = (ItemPipeConnectionBlock)patt0$temp;
                        boolean extracting = itemBlock.isSideExtractable(pipeState, targetDir.getOpposite());
                        return !extracting;
                    }).map(target -> new Tuple((Object)ItemApi.BLOCK.find(world, (BlockPos)target.getA(), (Direction)target.getB()), (Object)((BlockPos)target.getA()))).filter(obj -> Objects.nonNull(obj.getA()) && ((ItemApi.InventoryStorage)obj.getA()).supportsInsertion()).sorted(Comparator.comparingInt(a -> ((BlockPos)a.getB()).distManhattan((Vec3i)pos))).toList();
                    this.filteredTargetsNetHash = netHash;
                    this.cachedTransferPaths.clear();
                }
                int toMove = stackToMove.getCount();
                int moved = 0;
                for (Tuple<ItemApi.InventoryStorage, BlockPos> storagePair : this.filteredTargetItemStorages) {
                    if (((ItemApi.InventoryStorage)storagePair.getA()).equals(moveFromInventory)) continue;
                    ItemApi.InventoryStorage targetStorage = (ItemApi.InventoryStorage)storagePair.getA();
                    boolean wasEmptyStorage = IntStream.range(0, targetStorage.getSlotCount()).allMatch(slot -> targetStorage.getStackInSlot(slot).isEmpty());
                    int inserted = targetStorage.insert(stackToMove, false);
                    toMove -= inserted;
                    moved += inserted;
                    if (inserted > 0) {
                        this.onItemMoved(this.worldPosition, takenFrom, (BlockPos)storagePair.getB(), data.pipeNetworks.getOrDefault(data.pipeNetworkLinks.getOrDefault(this.worldPosition, 0), new HashSet()), world, stackToMove.getItem(), inserted, wasEmptyStorage);
                    }
                    if (toMove > 0) continue;
                    break;
                }
                if ((extracted = moveFromInventory.extract(stackToMove.copyWithCount(moved), false)) != moved) {
                    Oritech.LOGGER.warn("Invalid state while transferring inventory. Caused at position {}", (Object)pos);
                }
                if (moved > 0 || !hasMotor.booleanValue()) continue block0;
            }
        }
        if (moveCapacity > TRANSFER_AMOUNT) {
            this.onBoostUsed();
        }
    }

    private void onItemMoved(BlockPos startPos, BlockPos from, BlockPos to, Set<BlockPos> network, Level world, Item moved, int movedCount, boolean wasEmpty) {
        if (!this.renderItems) {
            return;
        }
        Tuple path = this.cachedTransferPaths.computeIfAbsent(to, ignored -> ItemPipeInterfaceEntity.calculatePath(startPos, from, to, network, world));
        if (path == null) {
            return;
        }
        ArrayList codedPath = (ArrayList)path.getA();
        int pathLength = 0;
        for (int i = 0; i < codedPath.size() - 1; ++i) {
            BlockPos pathPos = (BlockPos)codedPath.get(i);
            BlockPos nextPathPos = (BlockPos)codedPath.get(i + 1);
            pathLength += nextPathPos.distManhattan((Vec3i)pathPos);
        }
        RenderStackData packet = new RenderStackData(this.worldPosition, new ItemStack((ItemLike)moved, movedCount), codedPath, world.getGameTime(), pathLength);
        NetworkManager.sendBlockHandle(this, packet);
        if (wasEmpty) {
            long arrivalTime = world.getGameTime() + (long)((int)ItemPipeInterfaceEntity.calculatePathLength((Integer)path.getB()));
            blockedUntil.putIfAbsent(to, arrivalTime);
        }
    }

    public static double calculatePathLength(int pathBlocksCount) {
        return Math.pow(pathBlocksCount * 32, 0.6);
    }

    private static Tuple<ArrayList<BlockPos>, Integer> calculatePath(BlockPos startPos, BlockPos from, BlockPos to, Set<BlockPos> network, Level world) {
        BlockPos currentPos;
        if (network.isEmpty() || !network.contains(startPos)) {
            Oritech.LOGGER.warn("tried to calculate invalid item pipe from: {} to {} with network size: {}", new Object[]{startPos, to, network.size()});
            return null;
        }
        int length = 1;
        LinkedList<BlockPos> path = new LinkedList<BlockPos>();
        path.add(startPos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        StopWatch watch = new StopWatch();
        watch.start();
        for (int i = 0; i < network.size() * 3 && (currentPos = (BlockPos)path.peekLast()) != null && currentPos.distManhattan((Vec3i)to) != 1; ++i) {
            visited.add(currentPos);
            BlockState currentPosState = world.getBlockState(currentPos);
            Block block = currentPosState.getBlock();
            if (!(block instanceof AbstractPipeBlock)) break;
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)block;
            BlockPos[] openEdges = (BlockPos[])ItemPipeInterfaceEntity.getNeighbors(currentPos).stream().filter(network::contains).filter(candidate -> !visited.contains(candidate)).filter(candidate -> pipeBlock.isConnectingInDirection(currentPosState, ItemPipeInterfaceEntity.getDirectionFromOffset(currentPos, candidate), currentPos, world, false)).sorted(Comparator.comparingInt(a -> a.distManhattan((Vec3i)to))).toArray(BlockPos[]::new);
            if (openEdges.length == 0) {
                path.pollLast();
                continue;
            }
            path.add(openEdges[0]);
            ++length;
        }
        path.addFirst(from);
        path.add(to);
        ArrayList<BlockPos> result = ItemPipeInterfaceEntity.optimizePath(path);
        watch.stop();
        Oritech.LOGGER.debug("pathsize: {} success: {} time ms: {}", new Object[]{result.size(), path.size() > 2, Float.valueOf((float)watch.getNanoTime() / 1000000.0f)});
        return new Tuple(result, (Object)path.size());
    }

    private static ArrayList<BlockPos> optimizePath(LinkedList<BlockPos> path) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (path.isEmpty()) {
            return result;
        }
        Iterator iterator = path.iterator();
        BlockPos first = (BlockPos)iterator.next();
        result.add(first);
        if (!iterator.hasNext()) {
            return result;
        }
        BlockPos current = (BlockPos)iterator.next();
        BlockPos currentDirection = current.subtract((Vec3i)first);
        while (iterator.hasNext()) {
            BlockPos next = (BlockPos)iterator.next();
            BlockPos nextDirection = next.subtract((Vec3i)current);
            if (!nextDirection.equals((Object)currentDirection)) {
                result.add(current);
                currentDirection = nextDirection;
            }
            current = next;
        }
        result.add(current);
        return result;
    }

    private static List<BlockPos> getNeighbors(BlockPos pos) {
        return Arrays.asList(pos.below(), pos.above(), pos.north(), pos.east(), pos.south(), pos.west());
    }

    private static Direction getDirectionFromOffset(BlockPos self, BlockPos target) {
        BlockPos offset = target.subtract((Vec3i)self);
        return Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
    }

    public static void receiveVisualItemsPacket(RenderStackData message, Level world, RegistryAccess registryAccess) {
        Optional blockEntity = world.getBlockEntity(message.self, BlockEntitiesContent.ITEM_PIPE_ENTITY);
        if (blockEntity.isPresent()) {
            ItemPipeInterfaceEntity pipeEntity = (ItemPipeInterfaceEntity)((Object)blockEntity.get());
            pipeEntity.activeStacks.add(new RenderStackData(pipeEntity.worldPosition, message.rendered, message.path, world.getGameTime(), message.pathLength));
        }
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public record RenderStackData(BlockPos self, ItemStack rendered, List<BlockPos> path, Long startedAt, int pathLength) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RenderStackData> PIPE_ITEMS_ID = new CustomPacketPayload.Type(Oritech.id("pipe_items"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PIPE_ITEMS_ID;
        }
    }
}

