/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.renderers.MachineRenderer;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class UnstableContainerRenderer
extends MachineRenderer<UnstableContainerBlockEntity> {
    public UnstableContainerRenderer(String modelPath) {
        super(modelPath);
    }

    public void postRender(PoseStack poseStack, UnstableContainerBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        long time = animatable.getLevel().getGameTime();
        float totalTime = (float)time + partialTick;
        float rotationY = totalTime * 10.0f % 360.0f;
        if (animatable.capturedBlock == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.6f, 0.6f, 0.6f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.translate(-0.5, 0.0, -0.5);
        BlockRenderDispatcher renderManager = Minecraft.getInstance().getBlockRenderer();
        BakedModel renderedModel = renderManager.getBlockModel(animatable.capturedBlock);
        renderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)animatable.getLevel(), renderedModel, Blocks.GLOWSTONE.defaultBlockState(), animatable.getBlockPos(), poseStack, bufferSource.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)animatable.capturedBlock)), true, animatable.getLevel().random, animatable.capturedBlock.getSeed(animatable.getBlockPos()), 0xF000F0);
        poseStack.popPose();
    }
}

