/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.item.tools.LaserTargetDesignator;

public class DroneScreenHandler
extends UpgradableMachineScreenHandler {
    private final SimpleContainer cardInventory;

    public DroneScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.player.level().getBlockEntity(buf.readBlockPos())));
    }

    public DroneScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(syncId, playerInventory, blockEntity);
        if (!(blockEntity instanceof DronePortEntity)) {
            this.cardInventory = null;
            Oritech.LOGGER.error("Opened drone screen on non-drone block, this should never happen");
            return;
        }
        DronePortEntity dronePortEntity = (DronePortEntity)blockEntity;
        this.cardInventory = dronePortEntity.getCardInventory();
        this.cardInventory.startOpen(playerInventory.player);
        this.addCardSlots();
    }

    private void addCardSlots() {
        this.addSlot(new Slot((Container)this.cardInventory, 0, 130, 26));
        this.addSlot(new Slot((Container)this.cardInventory, 1, 130, 62));
    }

    @Override
    public int getPlayerInvEndSlot(ItemStack stack) {
        return super.getPlayerInvEndSlot(stack) - 2;
    }

    @Override
    public int getMachineInvStartSlot(ItemStack stack) {
        if (stack.getItem() instanceof LaserTargetDesignator) {
            return this.slots.size() - 2;
        }
        return super.getMachineInvStartSlot(stack);
    }

    @Override
    public int getMachineInvEndSlot(ItemStack stack) {
        if (stack.getItem() instanceof LaserTargetDesignator) {
            return this.slots.size();
        }
        return super.getMachineInvEndSlot(stack);
    }
}

