/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ReactorBlockRenderComponent
extends BaseComponent {
    private final Minecraft client = Minecraft.getInstance();
    public BlockState state;
    @Nullable
    private final BlockEntity entity;
    public float zIndex;
    public BlockPos pos;

    public ReactorBlockRenderComponent(@Nullable BlockState state, @Nullable BlockEntity entity, float zIndex, BlockPos pos) {
        this.state = state;
        this.entity = entity;
        this.zIndex = zIndex;
        this.pos = pos;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        BlockState usedState = this.state == null ? this.client.level.getBlockState(this.pos) : this.state;
        context.pose().pushPose();
        context.pose().translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, this.zIndex * 25.0f + 1000.0f);
        context.pose().scale((float)(40 * this.width) / 64.0f, (float)(-40 * this.height) / 64.0f, 40.0f);
        context.pose().mulPose(Axis.XP.rotationDegrees(30.0f));
        context.pose().mulPose(Axis.YP.rotationDegrees(225.0f));
        context.pose().translate(-0.5, -0.5, -0.5);
        RenderSystem.runAsFancy(() -> {
            BlockEntityRenderer renderer;
            MultiBufferSource.BufferSource vertexConsumers = this.client.renderBuffers().bufferSource();
            if (usedState.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                this.client.getBlockRenderer().renderSingleBlock(usedState, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            if (this.entity != null && (renderer = this.client.getBlockEntityRenderDispatcher().getRenderer(this.entity)) != null) {
                renderer.render(this.entity, partialTicks, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            RenderSystem.setShaderLights((Vector3f)new Vector3f(-1.5f, -0.5f, 0.0f), (Vector3f)new Vector3f(0.0f, -1.0f, 0.0f));
            vertexConsumers.endBatch();
            Lighting.setupFor3DItems();
        });
        context.pose().popPose();
    }
}

