/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.jei;

import io.wispforest.owo.ui.container.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.client.ui.ItemFilterScreen;

class JeiItemFilterGhostHandler
implements IGhostIngredientHandler<ItemFilterScreen> {
    JeiItemFilterGhostHandler() {
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(@NotNull ItemFilterScreen screen, @NotNull ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() != VanillaTypes.ITEM_STACK) {
            return targets;
        }
        for (int i = 0; i < 12; ++i) {
            targets.add(new ItemFilterTarget(screen, i));
        }
        return targets;
    }

    public void onComplete() {
    }

    static final class ItemFilterTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final ItemFilterScreen screen;
        private final int index;
        private final Rect2i area;

        ItemFilterTarget(ItemFilterScreen screen, int index) {
            this.screen = screen;
            this.index = index;
            FlowLayout container = screen.getItemContainer(index);
            this.area = new Rect2i(container.x(), container.y(), container.width(), container.height());
        }

        @NotNull
        public Rect2i getArea() {
            return this.area;
        }

        public void accept(@NotNull I itemStack) {
            this.screen.acceptItemStack(((ItemStack)itemStack).copyWithCount(1), this.index);
        }
    }
}

