/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.recipes;

import com.mojang.datafixers.util.Either;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;
import rearth.oritech.block.entity.augmenter.api.EffectAugment;
import rearth.oritech.block.entity.augmenter.api.ModifierAugment;
import rearth.oritech.init.recipes.AugmentDataRecipeType;
import rearth.oritech.util.SizedIngredient;

public class AugmentDataRecipe
implements Recipe<RecipeInput> {
    private final boolean toggleable;
    private final AugmentDataRecipeType type;
    private final List<SizedIngredient> researchCost;
    private final List<SizedIngredient> applyCost;
    private final List<ResourceLocation> requirements;
    private final ResourceLocation requiredStation;
    private final int uiX;
    private final int uiY;
    private final int time;
    private final long rfCost;
    @Nullable
    private final EffectDefinition effectDefinition;
    @Nullable
    private final ModifierDefinition modifierDefinition;
    @Nullable
    private final CustomAugmentDefinition customAugmentDefinition;

    public AugmentDataRecipe(AugmentDataRecipeType type, boolean toggleable, List<SizedIngredient> researchCost, List<SizedIngredient> applyCost, List<ResourceLocation> requirements, ResourceLocation requiredStation, int uiX, int uiY, int time, long rfCost, Either<Either<EffectDefinition, ModifierDefinition>, CustomAugmentDefinition> effect) {
        this(type, toggleable, researchCost, applyCost, requirements, requiredStation, uiX, uiY, time, rfCost, effect.left().isPresent() ? (((Either)effect.left().get()).left().isPresent() ? (EffectDefinition)((Either)effect.left().get()).left().get() : null) : null, effect.left().isPresent() ? (((Either)effect.left().get()).right().isPresent() ? (ModifierDefinition)((Either)effect.left().get()).right().get() : null) : null, effect.right().isPresent() ? (CustomAugmentDefinition)effect.right().get() : null);
    }

    public AugmentDataRecipe(AugmentDataRecipeType type, boolean toggleable, List<SizedIngredient> researchCost, List<SizedIngredient> applyCost, List<ResourceLocation> requirements, ResourceLocation requiredStation, int uiX, int uiY, int time, long rfCost, @Nullable EffectDefinition effectDefinition, @Nullable ModifierDefinition modifierDefinition, @Nullable CustomAugmentDefinition customAugmentDefinition) {
        this.toggleable = toggleable;
        this.researchCost = researchCost;
        this.applyCost = applyCost;
        this.requirements = requirements;
        this.requiredStation = requiredStation;
        this.uiX = uiX;
        this.uiY = uiY;
        this.time = time;
        this.rfCost = rfCost;
        this.effectDefinition = effectDefinition;
        this.modifierDefinition = modifierDefinition;
        this.customAugmentDefinition = customAugmentDefinition;
        this.type = type;
    }

    public boolean matches(RecipeInput input, Level world) {
        throw new UnsupportedOperationException();
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.type;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public AugmentDataRecipeType getOriType() {
        return this.type;
    }

    public boolean isToggleable() {
        return this.toggleable;
    }

    public Augment createAugment(ResourceLocation recipeId) {
        if (this.customAugmentDefinition != null) {
            ResourceLocation customId = this.customAugmentDefinition.customAugmentId;
            return CustomAugmentsCollection.getById(customId);
        }
        if (this.effectDefinition != null) {
            return new EffectAugment(recipeId, this.toggleable, (Holder<MobEffect>)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(this.effectDefinition.potionEffectId).orElseThrow()), this.effectDefinition.effectStrength);
        }
        if (this.modifierDefinition != null) {
            return new ModifierAugment(recipeId, (Holder<Attribute>)((Holder)BuiltInRegistries.ATTRIBUTE.getHolder(this.modifierDefinition.entityAttributeId).orElseThrow()), (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(this.modifierDefinition.attributeOperationType()), this.modifierDefinition.amount(), this.toggleable);
        }
        throw new IllegalStateException("No augment definition for " + String.valueOf(recipeId));
    }

    public List<SizedIngredient> getResearchCost() {
        return this.researchCost;
    }

    public List<SizedIngredient> getApplyCost() {
        return this.applyCost;
    }

    public long getRfCost() {
        return this.rfCost;
    }

    public int getTime() {
        return this.time;
    }

    public ResourceLocation getRequiredStation() {
        return this.requiredStation;
    }

    public List<ResourceLocation> getRequirements() {
        return this.requirements;
    }

    public int getUiX() {
        return this.uiX;
    }

    public int getUiY() {
        return this.uiY;
    }

    @Nullable
    public EffectDefinition getEffectDefinition() {
        return this.effectDefinition;
    }

    @Nullable
    public CustomAugmentDefinition getCustomAugmentDefinition() {
        return this.customAugmentDefinition;
    }

    @Nullable
    public ModifierDefinition getModifierDefinition() {
        return this.modifierDefinition;
    }

    public Either<Either<EffectDefinition, ModifierDefinition>, CustomAugmentDefinition> getDefinition() {
        if (this.effectDefinition != null) {
            return Either.left((Object)Either.left((Object)this.effectDefinition));
        }
        if (this.modifierDefinition != null) {
            return Either.left((Object)Either.right((Object)this.modifierDefinition));
        }
        if (this.customAugmentDefinition != null) {
            return Either.right((Object)this.customAugmentDefinition);
        }
        throw new IllegalStateException("Either effect, modifier or custom augment needs to be set!");
    }

    public record EffectDefinition(ResourceLocation potionEffectId, int effectStrength) {
        public static Endec<EffectDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(EffectDefinition.class);
    }

    public record ModifierDefinition(ResourceLocation entityAttributeId, int attributeOperationType, float amount) {
        public static Endec<ModifierDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(ModifierDefinition.class);
    }

    public record CustomAugmentDefinition(ResourceLocation customAugmentId) {
        public static Endec<CustomAugmentDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(CustomAugmentDefinition.class);
    }
}

