/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum ExplosiveLightingMode {
    OFF(ChatFormatting.RED, "OFF"),
    SIMPLE(ChatFormatting.YELLOW, "SIMPLE"),
    FANCY(ChatFormatting.GREEN, "FANCY");

    private final Component translatedText;

    private ExplosiveLightingMode(ChatFormatting formatting, String translatedText) {
        this.translatedText = Component.literal((String)translatedText).copy().withStyle(formatting);
    }

    public boolean isEnabled() {
        return this != OFF;
    }

    public ExplosiveLightingMode next() {
        ExplosiveLightingMode[] v = ExplosiveLightingMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public Component getTranslatedText() {
        return this.translatedText;
    }

    @NotNull
    public static Optional<ExplosiveLightingMode> byId(@NotNull String id) {
        return Arrays.stream(ExplosiveLightingMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }
}

