/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.SodiumDynamicLights;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    private int sodiumdynamiclights$luminance;

    @Shadow
    public abstract BlockState getDisplayBlockState();

    public AbstractMinecartEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.level().isClientSide()) {
            if (this.isRemoved()) {
                this.sdl$setDynamicLightEnabled(false);
            } else {
                if (!((Boolean)SodiumDynamicLights.get().config.getEntitiesLightSource().get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
                    this.sodiumdynamiclights$luminance = 0;
                } else {
                    this.sdl$dynamicLightTick();
                }
                SodiumDynamicLights.updateTracking(this);
            }
        }
    }

    @Override
    public void sdl$dynamicLightTick() {
        this.sodiumdynamiclights$luminance = Math.max(Math.max(this.isOnFire() ? 15 : 0, this.getDisplayBlockState().getLightEmission()), DynamicLightHandlers.getLuminanceFrom(this));
    }

    @Override
    public int sdl$getLuminance() {
        return this.sodiumdynamiclights$luminance;
    }
}

