/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.DynamicLightsMode;
import toni.sodiumdynamiclights.SodiumDynamicLights;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DynamicLightSource {
    @Shadow
    public Level level;
    @Unique
    protected int sodiumdynamiclights$luminance = 0;
    @Unique
    private int sodiumdynamiclights$lastLuminance = 0;
    @Unique
    private long sodiumdynamiclights$lastUpdate = 0L;
    @Unique
    private double sodiumdynamiclights$prevX;
    @Unique
    private double sodiumdynamiclights$prevY;
    @Unique
    private double sodiumdynamiclights$prevZ;
    @Unique
    private LongOpenHashSet sodiumdynamiclights$trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getEyeY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract boolean isOnFire();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract BlockPos getOnPos();

    @Shadow
    public abstract boolean isRemoved();

    @Shadow
    public abstract ChunkPos chunkPosition();

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.level.isClientSide()) {
            if (this.isRemoved()) {
                this.sdl$setDynamicLightEnabled(false);
            } else {
                this.sdl$dynamicLightTick();
                if (!((Boolean)SodiumDynamicLights.get().config.getEntitiesLightSource().get()).booleanValue() && this.getType() != EntityType.PLAYER || !DynamicLightHandlers.canLightUp((Entity)this)) {
                    this.sodiumdynamiclights$luminance = 0;
                }
                SodiumDynamicLights.updateTracking(this);
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="TAIL")})
    public void onRemove(CallbackInfo ci) {
        if (this.level.isClientSide()) {
            this.sdl$setDynamicLightEnabled(false);
        }
    }

    @Override
    public double sdl$getDynamicLightX() {
        return this.getX();
    }

    @Override
    public double sdl$getDynamicLightY() {
        return this.getEyeY();
    }

    @Override
    public double sdl$getDynamicLightZ() {
        return this.getZ();
    }

    @Override
    public Level sdl$getDynamicLightLevel() {
        return this.level;
    }

    @Override
    public void sdl$resetDynamicLight() {
        this.sodiumdynamiclights$lastLuminance = 0;
    }

    @Override
    public boolean sdl$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = SodiumDynamicLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.sodiumdynamiclights$lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.sodiumdynamiclights$lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public void sdl$dynamicLightTick() {
        this.sodiumdynamiclights$luminance = this.isOnFire() ? 15 : 0;
        int luminance = DynamicLightHandlers.getLuminanceFrom((Entity)this);
        if (luminance > this.sodiumdynamiclights$luminance) {
            this.sodiumdynamiclights$luminance = luminance;
        }
    }

    @Override
    public int sdl$getLuminance() {
        return this.sodiumdynamiclights$luminance;
    }

    @Override
    public boolean sodiumdynamiclights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.sdl$shouldUpdateDynamicLight()) {
            return false;
        }
        double deltaX = this.getX() - this.sodiumdynamiclights$prevX;
        double deltaY = this.getY() - this.sodiumdynamiclights$prevY;
        double deltaZ = this.getZ() - this.sodiumdynamiclights$prevZ;
        int luminance = this.sdl$getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.sodiumdynamiclights$lastLuminance) {
            this.sodiumdynamiclights$prevX = this.getX();
            this.sodiumdynamiclights$prevY = this.getY();
            this.sodiumdynamiclights$prevZ = this.getZ();
            this.sodiumdynamiclights$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = this.chunkPosition();
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.x, SectionPos.blockToSectionCoord((double)this.getEyeY()), entityChunkPos.z);
                SodiumDynamicLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                SodiumDynamicLights.updateTrackedChunks((BlockPos)chunkPos, this.sodiumdynamiclights$trackedLitChunkPos, newPos);
                Direction directionX = (this.getOnPos().getX() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (Mth.floor((double)this.getEyeY()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.getOnPos().getZ() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.move(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.move(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.move(directionX.getOpposite());
                    } else {
                        chunkPos.move(directionZ.getOpposite());
                        chunkPos.move(directionY);
                    }
                    SodiumDynamicLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    SodiumDynamicLights.updateTrackedChunks((BlockPos)chunkPos, this.sodiumdynamiclights$trackedLitChunkPos, newPos);
                }
            }
            this.sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer);
            this.sodiumdynamiclights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void sodiumdynamiclights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (Minecraft.getInstance().level == this.level) {
            LongIterator longIterator = this.sodiumdynamiclights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                SodiumDynamicLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

