/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.parts.automation.StackWorldBehaviors;
import es.degrassi.appexp.block.entity.ExperienceAcceptorEntity;
import es.degrassi.appexp.block.entity.ExperienceConverterEntity;
import es.degrassi.appexp.data.AppliedExperiencedDataGenerators;
import es.degrassi.appexp.definition.AExpBlockEntities;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpComponents;
import es.degrassi.appexp.definition.AExpConfig;
import es.degrassi.appexp.definition.AExpItems;
import es.degrassi.appexp.definition.AExpMenus;
import es.degrassi.appexp.me.cell.ExperienceCellHandler;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import es.degrassi.appexp.me.misc.GenericStackExperienceStorage;
import es.degrassi.appexp.me.strategy.ExperienceContainerItemStrategy;
import es.degrassi.appexp.me.strategy.ExperienceExternalStorageStrategy;
import es.degrassi.appexp.me.strategy.ExperienceStackExportStrategy;
import es.degrassi.appexp.me.strategy.ExperienceStackImportStrategy;
import es.degrassi.appexp.part.ExperienceAcceptorPart;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="appex")
public class AppliedExperienced {
    public static final String MODID = "appex";
    public static final Logger LOGGER = LogManager.getLogger((String)"Applied Experienced");

    public AppliedExperienced(ModContainer CONTAINER, IEventBus bus) {
        CONTAINER.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AExpConfig.getSpec());
        AExpItems.initialize(bus);
        AExpBlocks.DR.register(bus);
        AExpBlockEntities.DR.register(bus);
        AExpComponents.initialize(bus);
        AExpMenus.initialize(bus);
        bus.addListener(AppliedExperiencedDataGenerators::onGatherData);
        bus.addListener(ExperienceKeyType::register);
        StorageCells.addCellHandler((ICellHandler)ExperienceCellHandler.INSTANCE);
        bus.addListener(AExpItems::initCellUpgrades);
        StackWorldBehaviors.registerImportStrategy((AEKeyType)ExperienceKeyType.TYPE, ExperienceStackImportStrategy::new);
        StackWorldBehaviors.registerExportStrategy((AEKeyType)ExperienceKeyType.TYPE, ExperienceStackExportStrategy::new);
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)ExperienceKeyType.TYPE, ExperienceExternalStorageStrategy::new);
        ContainerItemStrategy.register((AEKeyType)ExperienceKeyType.TYPE, ExperienceKey.class, (ContainerItemStrategy)new ExperienceContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)ExperienceKeyType.TYPE, (Long)10000L);
        bus.addListener(GenericStackExperienceStorage::registerCapability);
        bus.addListener(ExperienceConverterEntity::registerCapability);
        bus.addListener(ExperienceAcceptorEntity::registerCapability);
        bus.addListener(ExperienceAcceptorPart::registerCapability);
        bus.addListener(event -> event.enqueueWork(this::initializeAttunement));
    }

    private void initializeAttunement() {
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

