/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.client.screen;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import es.degrassi.appexp.client.container.ExperienceConverterContainer;
import es.degrassi.appexp.client.widgets.ExperienceWidget;
import es.degrassi.appexp.client.widgets.Icon;
import es.degrassi.appexp.client.widgets.IconButton;
import es.degrassi.appexp.definition.AExpText;
import es.degrassi.appexp.network.client.CExperienceButtonClickedPacket;
import guideme.PageAnchor;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ExperienceConverterScreen
extends AEBaseScreen<ExperienceConverterContainer> {
    public ExperienceConverterScreen(ExperienceConverterContainer menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.widgets.add("experience", (AbstractWidget)new ExperienceWidget(this.getXSize(), menu));
        for (Amount value : Amount.values()) {
            this.widgets.add("extract_" + value.nameL(), (AbstractWidget)new ExperienceButton(true, value, btn -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(menu.entity.getBlockPos(), value, true), (CustomPacketPayload[])new CustomPacketPayload[0])));
            this.widgets.add("insert_" + value.nameL(), (AbstractWidget)new ExperienceButton(false, value, btn -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(menu.entity.getBlockPos(), value, false), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }

    protected boolean shouldAddToolbar() {
        return false;
    }

    @Nullable
    protected PageAnchor getHelpTopic() {
        return null;
    }

    public static enum Amount {
        ONE("1", 1),
        TEN("10", 10),
        HUNDRED("100", 100),
        ALL("All");

        private final String formatted;
        private int amount = 0;

        private Amount(String formatted, int amount) {
            this(formatted);
            this.amount = amount;
        }

        private Amount(String formatted) {
            this.formatted = formatted;
        }

        public String nameL() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isAll() {
            return this == ALL;
        }

        Icon getIcon(boolean extraction) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (extraction) {
                        yield Icon.XP_EXTRACT_1;
                    }
                    yield Icon.XP_INSERT_1;
                }
                case 1 -> {
                    if (extraction) {
                        yield Icon.XP_EXTRACT_10;
                    }
                    yield Icon.XP_INSERT_10;
                }
                case 2 -> {
                    if (extraction) {
                        yield Icon.XP_EXTRACT_100;
                    }
                    yield Icon.XP_INSERT_100;
                }
                case 3 -> extraction ? Icon.XP_EXTRACT_ALL : Icon.XP_INSERT_ALL;
            };
        }

        public int getAmount(boolean extraction) {
            return extraction ? this.amount : -this.amount;
        }

        public Component message(boolean extraction) {
            return (extraction ? AExpText.EXPERIENCE_BUTTON_EXTRACT : AExpText.EXPERIENCE_BUTTON_INSERT).formatted(this.getFormatted(), "level(s)");
        }

        @Generated
        public String getFormatted() {
            return this.formatted;
        }

        @Generated
        public int getAmount() {
            return this.amount;
        }
    }

    private static class ExperienceButton
    extends IconButton {
        protected ExperienceButton(boolean extraction, Amount amount, Button.OnPress onPress) {
            super(onPress);
            this.setIcon(amount.getIcon(extraction));
            this.setMessage(amount.message(extraction));
        }
    }
}

