/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.util.inv.filter;

import appeng.api.inventories.InternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ApexItemFilters {
    public static final IAEItemFilter INSERT_ONLY = new InsertOnlyFilter(Items.EXPERIENCE_BOTTLE);
    public static final IAEItemFilter EXTRACT_ONLY = new ExtractOnlyFilter(Items.GLASS_BOTTLE);

    private ApexItemFilters() {
    }

    private static class InsertOnlyFilter
    implements IAEItemFilter {
        private final Predicate<ItemStack> filter = stack -> stack.is(filter);

        protected InsertOnlyFilter(Item filter) {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return this.filter.test(inv.getStackInSlot(slot));
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return this.filter.test(stack);
        }
    }

    private static class ExtractOnlyFilter
    implements IAEItemFilter {
        private final Predicate<ItemStack> filter = stack -> stack.is(filter);

        protected ExtractOnlyFilter(Item filter) {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return this.filter.test(inv.getStackInSlot(slot));
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return this.filter.test(stack);
        }
    }
}

