/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.setup.gear.PartTypes;

public interface GearTool
extends GearItem {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.ROD.get())));

    default public Tool createToolProperties(GearPropertiesData properties) {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    default public boolean isValidSlot(String slot) {
        return EquipmentSlot.MAINHAND.getName().equalsIgnoreCase(slot) || EquipmentSlot.OFFHAND.getName().equalsIgnoreCase(slot);
    }

    @Override
    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    default public int getDamageOnBlockBreak(ItemStack gear, Level world, BlockState state, BlockPos pos) {
        return !state.is(BlockTags.LEAVES) && state.getDestroySpeed((BlockGetter)world, pos) > 0.0f ? 1 : 0;
    }

    default public int getDamageOnHitEntity(ItemStack gear, LivingEntity target, LivingEntity attacker) {
        return 2;
    }
}

