/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.lib.collection.StackList;

public class FillRepairKitRecipe
extends CustomRecipe {
    public FillRepairKitRecipe(CraftingBookCategory bookCategory) {
        super(bookCategory);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        boolean kitFound = false;
        int matsFound = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof RepairKitItem) {
                if (kitFound) {
                    return false;
                }
                kitFound = true;
                continue;
            }
            if (FillRepairKitRecipe.isRepairMaterial(stack)) {
                ++matsFound;
                continue;
            }
            return false;
        }
        return kitFound && matsFound > 0;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        StackList list = StackList.from((CraftingInput)inv);
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class).copy();
        repairKit.setCount(1);
        RepairKitItem repairKitItem = (RepairKitItem)repairKit.getItem();
        for (ItemStack mat : list.allMatches(FillRepairKitRecipe::isRepairMaterial)) {
            if (repairKitItem.addMaterial(repairKit, mat)) continue;
            return ItemStack.EMPTY;
        }
        return repairKit;
    }

    private static boolean isRepairMaterial(ItemStack stack) {
        MaterialInstance material = MaterialInstance.from(stack);
        return material != null && FillRepairKitRecipe.isRepairMaterial(material);
    }

    private static boolean isRepairMaterial(MaterialInstance material) {
        float durability = ((Float)material.getProperty((Supplier<PartType>)PartTypes.MAIN, PropertyKey.of(GearProperties.DURABILITY, GearTypes.ALL))).floatValue();
        float armorDurability = ((Float)material.getProperty((Supplier<PartType>)PartTypes.MAIN, PropertyKey.of(GearProperties.ARMOR_DURABILITY, GearTypes.ALL))).floatValue();
        Material mat = material.get();
        return mat != null && mat.isAllowedInPart(material, (PartType)PartTypes.MAIN.get()) && (durability > 0.0f || armorDurability > 0.0f);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.FILL_REPAIR_KIT.get();
    }
}

