/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import org.jetbrains.annotations.Nullable;

public final class NumberPropertyModifierTraitEffect
extends TraitEffect {
    private static final Codec<NumberProperty> KEY_CODEC = SgRegistries.GEAR_PROPERTY.byNameCodec().comapFlatMap(property -> {
        if (property instanceof NumberProperty) {
            NumberProperty numberProperty = (NumberProperty)property;
            return DataResult.success((Object)numberProperty);
        }
        return DataResult.error(() -> "Not a NumberProperty: " + String.valueOf(SgRegistries.GEAR_PROPERTY.getKey(property)));
    }, numberProperty -> numberProperty);
    public static final MapCodec<NumberPropertyModifierTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(KEY_CODEC, StatMod.CODEC).fieldOf("property_modifiers").forGetter(e -> e.mods)).apply((Applicative)instance, NumberPropertyModifierTraitEffect::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, NumberProperty> KEY_STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeResourceLocation(Objects.requireNonNull(SgRegistries.GEAR_PROPERTY.getKey(val))), buf -> (NumberProperty)SgRegistries.GEAR_PROPERTY.get(buf.readResourceLocation()));
    public static final StreamCodec<RegistryFriendlyByteBuf, NumberPropertyModifierTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, KEY_STREAM_CODEC, StatMod.STREAM_CODEC), e -> e.mods, NumberPropertyModifierTraitEffect::new);
    private final Map<NumberProperty, StatMod> mods = new LinkedHashMap<NumberProperty, StatMod>();

    public NumberPropertyModifierTraitEffect(Map<NumberProperty, StatMod> modsIn) {
        this.mods.putAll(modsIn);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.NUMBER_PROPERTY_MODIFIER.get();
    }

    @Override
    public Collection<GearPropertyValue<?>> getBonusProperties(int traitLevel, @Nullable Player player, GearProperty<?, ?> property, GearPropertyValue<?> baseValue, float damageRatio) {
        if (property instanceof NumberProperty) {
            NumberProperty numberProperty = (NumberProperty)property;
            StatMod propertyMod = this.mods.get(property);
            if (propertyMod != null) {
                NumberPropertyValue numberPropertyValue = (NumberPropertyValue)baseValue;
                float bonusValue = propertyMod.getAddedValue(traitLevel, ((Float)numberPropertyValue.value()).floatValue(), damageRatio);
                return List.of(new NumberPropertyValue(bonusValue, NumberProperty.Operation.ADD));
            }
        }
        return super.getBonusProperties(traitLevel, player, property, baseValue, damageRatio);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        this.mods.forEach((stat, mod) -> ret.add("  - " + stat.getDisplayName().getString() + ": " + mod.multiplier + " * level" + (mod.multiplyDamageRatio ? " * damage" : "") + (mod.multiplyOriginalValue ? " * value" : "")));
        return ret;
    }

    public static final class Builder {
        private final Map<NumberProperty, StatMod> map = new LinkedHashMap<NumberProperty, StatMod>();

        public Builder add(Supplier<NumberProperty> property, float multiplier, boolean multiplyDamageRatio, boolean multiplyOriginalValue) {
            this.map.put(property.get(), new StatMod(multiplier, multiplyDamageRatio, multiplyOriginalValue));
            return this;
        }

        public NumberPropertyModifierTraitEffect build() {
            return new NumberPropertyModifierTraitEffect(this.map);
        }
    }

    public record StatMod(float multiplier, boolean multiplyDamageRatio, boolean multiplyOriginalValue) {
        public static final Codec<StatMod> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("base_multiplier").forGetter(m -> Float.valueOf(m.multiplier)), (App)Codec.BOOL.fieldOf("multiply_damage_ratio").forGetter(m -> m.multiplyDamageRatio), (App)Codec.BOOL.fieldOf("multiply_original_value").forGetter(m -> m.multiplyOriginalValue)).apply((Applicative)instance, StatMod::new));
        public static final StreamCodec<FriendlyByteBuf, StatMod> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, m -> Float.valueOf(m.multiplier), (StreamCodec)ByteBufCodecs.BOOL, m -> m.multiplyDamageRatio, (StreamCodec)ByteBufCodecs.BOOL, m -> m.multiplyOriginalValue, StatMod::new);

        private float getAddedValue(int traitLevel, float originalValue, float damageRatio) {
            float addedValue = this.multiplier * (float)traitLevel;
            if (this.multiplyDamageRatio) {
                addedValue *= damageRatio;
            }
            if (this.multiplyOriginalValue) {
                addedValue *= originalValue;
            }
            return addedValue;
        }
    }
}

