/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common;

import com.illusivesoulworks.polymorph.common.PolymorphCommonEvents;
import com.illusivesoulworks.polymorph.server.PolymorphCommands;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class CommonEventsListener {
    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        PolymorphCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PolymorphCommonEvents.playerDisconnected(serverPlayer);
        }
    }

    @SubscribeEvent
    public void openContainer(PlayerContainerEvent.Open evt) {
        PolymorphCommonEvents.openContainer(evt.getEntity(), evt.getContainer());
    }

    @SubscribeEvent
    public void levelTick(LevelTickEvent.Post evt) {
        PolymorphCommonEvents.levelTick(evt.getLevel());
    }
}

