/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.EnumSet;
import java.util.Locale;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CATEGORY_FORMATTING = "formatting";
    private final ModConfigSpec config;
    private final ModConfigSpec.ConfigValue<String> modNameFormatFriendly;
    @Nullable
    private String cachedModNameFormat;

    public Config() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        EnumSet<ChatFormatting> validFormatting = EnumSet.allOf(ChatFormatting.class);
        validFormatting.remove(ChatFormatting.RESET);
        StringJoiner validColorsJoiner = new StringJoiner(", ");
        StringJoiner validFormatsJoiner = new StringJoiner(", ");
        for (ChatFormatting chatFormatting : validFormatting) {
            String lowerCaseName = chatFormatting.getName().toLowerCase(Locale.ENGLISH);
            if (chatFormatting.isColor()) {
                validColorsJoiner.add(lowerCaseName);
                continue;
            }
            if (!chatFormatting.isFormat()) continue;
            validFormatsJoiner.add(lowerCaseName);
        }
        String validColors = validColorsJoiner.toString();
        String validFormats = validFormatsJoiner.toString();
        builder.push(CATEGORY_FORMATTING);
        this.modNameFormatFriendly = builder.comment(new String[]{"How the mod name should be formatted in the tooltip. Leave blank to disable.", "Use these formatting colors:", validColors, "With these formatting options:", validFormats}).translation("config.modnametooltip.formatting.modNameFormat").define("modNameFormat", (Object)"blue italic");
        this.config = builder.build();
    }

    public ModConfigSpec getConfigSpec() {
        return this.config;
    }

    public String getModNameFormat() {
        if (this.cachedModNameFormat == null) {
            this.cachedModNameFormat = Config.parseFriendlyModNameFormat((String)this.modNameFormatFriendly.get());
        }
        return this.cachedModNameFormat;
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            ChatFormatting valueByName = ChatFormatting.getByName((String)string);
            if (valueByName != null) {
                format.append(valueByName);
                continue;
            }
            LOGGER.error("Invalid format: {}", (Object)string);
        }
        return format.toString();
    }

    public void onConfigChanged(ModConfigEvent event) {
        if ("modnametooltip".equals(event.getConfig().getModId())) {
            this.cachedModNameFormat = null;
        }
    }
}

