/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import mekanism.api.MekanismIMC;
import mekanism.api.functions.ConstantPredicates;
import mekanism.client.ClientRegistrationUtil;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.ComponentBackedNoClampEnergyContainer;
import mekanism.common.attachments.containers.energy.EnergyContainersBuilder;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigHelper;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemModule;
import mekanism.common.registration.impl.ContainerTypeDeferredRegister;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.EntityTypeDeferredRegister;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registries.MekanismCreativeTabs;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.WeaponsConfig;
import meranha.mekaweapons.client.GuiMagnetizer;
import meranha.mekaweapons.client.MagnetizerContainer;
import meranha.mekaweapons.client.MekaArrowRenderer;
import meranha.mekaweapons.client.WeaponsRenderer;
import meranha.mekaweapons.items.ItemMagnetizer;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.MekaArrowEntity;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="mekaweapons")
public class MekaWeapons {
    public static final String MODID = "mekaweapons";
    public static final Logger logger = LogUtils.getLogger();
    public static final WeaponsConfig general = new WeaponsConfig();
    private static final Map<IConfigSpec, IMekanismConfig> KNOWN_CONFIGS = new HashMap<IConfigSpec, IMekanismConfig>();
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekaweapons");
    public static final ItemRegistryObject<ItemMekaTana> MEKA_TANA = ITEMS.registerUnburnable("meka_tana", ItemMekaTana::new).addAttachedContainerCapabilities(ContainerType.ENERGY, () -> EnergyContainersBuilder.builder().addContainer((type, attachedTo, containerIndex) -> new ComponentBackedNoClampEnergyContainer(attachedTo, containerIndex, BasicEnergyContainer.manualOnly, ConstantPredicates.alwaysTrue(), () -> ModuleEnergyUnit.getChargeRate((ItemStack)attachedTo, (LongSupplier)MekaWeapons.general.mekaTanaBaseChargeRate), () -> ModuleEnergyUnit.getEnergyCapacity((ItemStack)attachedTo, (LongSupplier)MekaWeapons.general.mekaTanaBaseEnergyCapacity))).build(), new IMekanismConfig[]{general});
    public static final ItemRegistryObject<ItemMekaBow> MEKA_BOW = ITEMS.registerUnburnable("meka_bow", ItemMekaBow::new).addAttachedContainerCapabilities(ContainerType.ENERGY, () -> EnergyContainersBuilder.builder().addContainer((type, attachedTo, containerIndex) -> new ComponentBackedNoClampEnergyContainer(attachedTo, containerIndex, BasicEnergyContainer.manualOnly, ConstantPredicates.alwaysTrue(), () -> ModuleEnergyUnit.getChargeRate((ItemStack)attachedTo, (LongSupplier)MekaWeapons.general.mekaBowBaseChargeRate), () -> ModuleEnergyUnit.getEnergyCapacity((ItemStack)attachedTo, (LongSupplier)MekaWeapons.general.mekaBowBaseEnergyCapacity))).build(), new IMekanismConfig[]{general});
    public static final ItemRegistryObject<ItemMagnetizer> MAGNETIZER = ITEMS.registerUnburnable("magnetizer", ItemMagnetizer::new);
    public static final ItemRegistryObject<Item> KATANA_BLADE = ITEMS.register("katana_blade");
    public static final ItemRegistryObject<Item> BOW_RISER = ITEMS.register("bow_riser");
    public static final ItemRegistryObject<Item> BOW_LIMB = ITEMS.register("bow_limb");
    public static final ItemRegistryObject<ItemModule> MODULE_ARROWENERGY = ITEMS.registerModule(WeaponsModules.ARROWENERGY_UNIT, Rarity.RARE);
    public static final ItemRegistryObject<ItemModule> MODULE_AUTOFIRE = ITEMS.registerModule(WeaponsModules.AUTOFIRE_UNIT, Rarity.RARE);
    public static final ItemRegistryObject<ItemModule> MODULE_DRAWSPEED = ITEMS.registerModule(WeaponsModules.DRAWSPEED_UNIT, Rarity.RARE);
    public static final ItemRegistryObject<ItemModule> MODULE_GRAVITYDAMPENER = ITEMS.registerModule(WeaponsModules.GRAVITYDAMPENER_UNIT, Rarity.EPIC);
    public static final ItemRegistryObject<ItemModule> MODULE_ATTACKAMPLIFICATION = ITEMS.registerModule(WeaponsModules.ATTACKAMPLIFICATION_UNIT, Rarity.UNCOMMON);
    public static final ItemRegistryObject<ItemModule> MODULE_SWEEPING = ITEMS.registerModule(WeaponsModules.SWEEPING_UNIT, Rarity.UNCOMMON);
    public static final ItemRegistryObject<ItemModule> MODULE_LOOTING = ITEMS.registerModule(WeaponsModules.LOOTING_UNIT, Rarity.UNCOMMON);
    public static final EntityTypeDeferredRegister ENTITY_TYPES = new EntityTypeDeferredRegister("mekaweapons");
    public static final DeferredHolder<EntityType<?>, EntityType<MekaArrowEntity>> MEKA_ARROW = ENTITY_TYPES.register("meka_arrow", () -> EntityType.Builder.of(MekaArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("mekaweapons:meka_arrow"));
    public static final ContainerTypeDeferredRegister CONTAINER_TYPES = new ContainerTypeDeferredRegister("mekaweapons");
    public static final ContainerTypeRegistryObject<MagnetizerContainer> MAGNETIZER_CONTAINER = CONTAINER_TYPES.register(MAGNETIZER, ItemMagnetizer.class, MagnetizerContainer::new);

    public MekaWeapons(IEventBus modEventBus, ModContainer modContainer) {
        ITEMS.register(modEventBus);
        WeaponsModules.MODULES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        MekanismConfigHelper.registerConfig(KNOWN_CONFIGS, (ModContainer)modContainer, (IMekanismConfig)general);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::buildCreativeModeTabContents);
        modEventBus.addListener(this::sendCustomModules);
        modEventBus.addListener(this::registerRenderers);
        NeoForge.EVENT_BUS.addListener(this::mekaBowEnergyArrows);
        NeoForge.EVENT_BUS.addListener(this::disableMekaBowAttack);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static ResourceLocation getResource(@NotNull MekanismUtils.ResourceType type, String name) {
        return MekaWeapons.rl(type.getPrefix() + name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        logger.info("Loaded 'Mekanism: Weapons' module.");
    }

    private void buildCreativeModeTabContents(@NotNull BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == MekanismCreativeTabs.MEKANISM.get()) {
            ITEMS.getEntries().forEach(entry -> event.accept((ItemLike)entry.get()));
        }
    }

    private void sendCustomModules(InterModEnqueueEvent event) {
        String ADD_MEKA_TANA_MODULES = "add_meka_tana_modules";
        String ADD_MEKA_BOW_MODULES = "add_meka_bow_modules";
        MekanismIMC.addModuleContainer(MEKA_TANA, (String)"add_meka_tana_modules");
        MekanismIMC.addModuleContainer(MEKA_BOW, (String)"add_meka_bow_modules");
        MekanismIMC.sendModuleIMC((String)"add_meka_tana_modules", (Holder[])new Holder[]{MekanismModules.ENERGY_UNIT, WeaponsModules.ATTACKAMPLIFICATION_UNIT, MekanismModules.TELEPORTATION_UNIT, WeaponsModules.SWEEPING_UNIT, WeaponsModules.LOOTING_UNIT});
        MekanismIMC.sendModuleIMC((String)"add_meka_bow_modules", (Holder[])new Holder[]{MekanismModules.ENERGY_UNIT, WeaponsModules.ATTACKAMPLIFICATION_UNIT, WeaponsModules.AUTOFIRE_UNIT, WeaponsModules.ARROWENERGY_UNIT, WeaponsModules.DRAWSPEED_UNIT, WeaponsModules.GRAVITYDAMPENER_UNIT, WeaponsModules.LOOTING_UNIT});
    }

    private void mekaBowEnergyArrows(@NotNull LivingGetProjectileEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || !((player = (Player)livingEntity).level() instanceof ServerLevel)) {
            return;
        }
        ItemStack stack = event.getProjectileWeaponItemStack();
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ItemMekaBow mekaBow;
            ProjectileWeaponItem bow = (ProjectileWeaponItem)item;
            item = stack.getItem();
            if (item instanceof ItemMekaBow && (mekaBow = (ItemMekaBow)item).isModuleEnabled(stack, (Holder)WeaponsModules.ARROWENERGY_UNIT)) {
                ItemStack defaultCreativeAmmo = bow.getDefaultCreativeAmmo(player, stack);
                event.setProjectileItemStack(defaultCreativeAmmo);
            }
        }
    }

    private void disableMekaBowAttack(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ItemMekaBow) {
            event.setCanceled(true);
        }
    }

    public void registerRenderers(@NotNull EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MEKA_ARROW.get(), MekaArrowRenderer::new);
    }

    @EventBusSubscriber(modid="mekaweapons", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (ModList.get().isLoaded("curios")) {
                CuriosRendererRegistry.register((Item)((Item)MAGNETIZER.get()), WeaponsRenderer::new);
            }
            event.enqueueWork(() -> {
                ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pull"), (stack, world, entity, seed) -> {
                    Item patt0$temp;
                    if (entity != null && entity.getUseItem() == stack && (patt0$temp = stack.getItem()) instanceof ItemMekaBow) {
                        ItemMekaBow bow = (ItemMekaBow)patt0$temp;
                        return (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / bow.getUseTick(stack);
                    }
                    return 0.0f;
                });
                ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
            });
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            ClientRegistrationUtil.registerScreen((RegisterMenuScreensEvent)event, MAGNETIZER_CONTAINER, GuiMagnetizer::new);
        }
    }
}

