/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items.modules;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.client.WeaponsLang;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public record WeaponAttackAmplificationUnit(AttackDamage attackDamage) implements ICustomModule<WeaponAttackAmplificationUnit>
{
    public static final ResourceLocation ATTACK_DAMAGE = Mekanism.rl((String)"bonus_attack_damage");
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("attack_damage");
    private static final Int2ObjectMap<Lazy<NestedRadialMode>> RADIAL_DATAS = (Int2ObjectMap)Util.make(() -> {
        int types = AttackDamage.values().length - 2;
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(types);
        for (int type = 1; type <= types; ++type) {
            int accessibleValues = type + 2;
            map.put(type, (Object)Lazy.of(() -> new NestedRadialMode(IRadialDataHelper.INSTANCE.dataForTruncated(RADIAL_ID, accessibleValues, (Enum)AttackDamage.MED), (ILangEntry)WeaponsLang.RADIAL_ATTACK_DAMAGE, AttackDamage.MED.icon(), EnumColor.RED)));
        }
        return map;
    });

    public WeaponAttackAmplificationUnit(IModule<WeaponAttackAmplificationUnit> module) {
        this((AttackDamage)((Object)module.getConfigOrThrow(ATTACK_DAMAGE).get()));
    }

    public void addHUDStrings(IModule<WeaponAttackAmplificationUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled()) {
            hudStringAdder.accept((Component)MekanismLang.MODULE_DAMAGE.translateColored(EnumColor.DARK_GRAY, new Object[]{EnumColor.INDIGO, this.getCurrentMaxDamage(stack)}));
        }
    }

    @NotNull
    private NestedRadialMode getNestedData(IModule<WeaponAttackAmplificationUnit> module) {
        return (NestedRadialMode)((Lazy)RADIAL_DATAS.get(module.getInstalledCount())).get();
    }

    @NotNull
    private RadialData<?> getRadialData(IModule<WeaponAttackAmplificationUnit> module) {
        return this.getNestedData(module).nestedData();
    }

    public void addRadialModes(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack, Consumer<NestedRadialMode> adder) {
        adder.accept(this.getNestedData(module));
    }

    public int getCurrentUnit() {
        return this.attackDamage.ordinal();
    }

    @Nullable
    public <MODE extends IRadialMode> MODE getMode(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack, RadialData<MODE> radialData) {
        return (MODE)((Object)(radialData == this.getRadialData(module) ? this.attackDamage : null));
    }

    public <MODE extends IRadialMode> boolean setMode(IModule<WeaponAttackAmplificationUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, RadialData<MODE> radialData, MODE mode) {
        AttackDamage newMode;
        if (radialData == this.getRadialData(module) && this.attackDamage != (newMode = (AttackDamage)mode)) {
            moduleContainer.replaceModuleConfig((HolderLookup.Provider)player.registryAccess(), stack, module.getDataHolder(), module.getConfigOrThrow(ATTACK_DAMAGE).with((Object)newMode));
            return true;
        }
        return false;
    }

    @NotNull
    public Component getModeScrollComponent(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack) {
        return MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.INDIGO, new Object[]{this.attackDamage.sliceName(), EnumColor.AQUA, this.getCurrentMaxDamage(stack)});
    }

    public void changeMode(IModule<WeaponAttackAmplificationUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        AttackDamage newMode = (AttackDamage)this.attackDamage.adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 2);
        if (this.attackDamage != newMode) {
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_EFFICIENCY.translate(), (IHasTextComponent)newMode);
            }
            moduleContainer.replaceModuleConfig((HolderLookup.Provider)player.registryAccess(), stack, module.getDataHolder(), module.getConfigOrThrow(ATTACK_DAMAGE).with((Object)newMode));
        }
    }

    private int getCurrentMaxDamage(ItemStack stack) {
        return MekaWeaponsUtils.getBaseDamage(stack) * this.getCurrentUnit();
    }

    @NothingNullByDefault
    public static enum AttackDamage implements IIncrementalEnum<AttackDamage>,
    IHasTextComponent,
    TranslatableEnum,
    IRadialMode,
    StringRepresentable
    {
        OFF(WeaponsLang.RADIAL_TOGGLE_OFF, EnumColor.WHITE, "off"),
        LOW(WeaponsLang.RADIAL_ATTACK_DAMAGE_LOW, EnumColor.PINK, "damage_low"),
        MED(WeaponsLang.RADIAL_ATTACK_DAMAGE_MEDIUM, EnumColor.BRIGHT_GREEN, "damage_medium"),
        HIGH(WeaponsLang.RADIAL_ATTACK_DAMAGE_HIGH, EnumColor.YELLOW, "damage_high"),
        SUPER_HIGH(WeaponsLang.RADIAL_ATTACK_DAMAGE_SUPER, EnumColor.ORANGE, "damage_super"),
        EXTREME(WeaponsLang.RADIAL_ATTACK_DAMAGE_EXTREME, EnumColor.RED, "damage_extreme");

        public static final Codec<AttackDamage> CODEC;
        public static final IntFunction<AttackDamage> BY_ID;
        public static final StreamCodec<ByteBuf, AttackDamage> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final Component label;
        private final ResourceLocation icon;
        private final Component sliceNamePreCalc;

        private AttackDamage(ILangEntry langEntry, EnumColor color, String texture) {
            this.icon = MekaWeapons.getResource(MekanismUtils.ResourceType.GUI_RADIAL, texture + ".png");
            this.label = TextComponentUtil.getString((String)Integer.toString(this.ordinal()));
            this.sliceNamePreCalc = langEntry.translateColored(color);
        }

        public Component getTextComponent() {
            return this.label;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public Component getTranslatedName() {
            return this.sliceName();
        }

        public Component sliceName() {
            return this.sliceNamePreCalc;
        }

        public ResourceLocation icon() {
            return this.icon;
        }

        public AttackDamage byIndex(int index) {
            return BY_ID.apply(index);
        }

        static {
            CODEC = StringRepresentable.fromEnum(AttackDamage::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])AttackDamage.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

