/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.gui.handler.WoodcutterGuiHandler;
import net.satisfy.meadow.core.recipes.WoodcuttingRecipe;

public class WoodcutterGui
extends AbstractContainerScreen<WoodcutterGuiHandler> {
    private static final ResourceLocation TEXTURE = Meadow.identifier("textures/gui/woodcutter.png");
    private final int recipeIconPosX = 58;
    private final int recipeIconPosY = 15;
    private final int maxRecipeIcons = 12;
    private final int recipeIconWidth = 16;
    private final int recipeIconHeight = 18;
    private final int recipeIconPerLine = 4;
    private boolean canCraft;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;

    public WoodcutterGui(WoodcutterGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int posX = this.leftPos;
        int posY = this.topPos;
        context.blit(TEXTURE, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollAmount);
        if (this.shouldScroll()) {
            context.blit(TEXTURE, posX + 124, posY + 14 + k, 176, 0, 11, 15);
        }
        int recipeX = posX + 58;
        int recipeY = posY + 15;
        int scrollOffsetOFF = this.scrollOffset + 12;
        this.renderRecipeBackground(context, mouseX, mouseY, recipeX, recipeY, scrollOffsetOFF);
        this.renderRecipeIcons(context, recipeX, recipeY, scrollOffsetOFF);
    }

    private void renderRecipeBackground(GuiGraphics context, int mouseX, int mouseY, int x, int y, int scrollOffsetOFF) {
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.menu).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int posX = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int posY = y + 18 * l;
            int offsetY = this.imageHeight;
            if (i == ((WoodcutterGuiHandler)this.menu).getSelectedRecipe()) {
                offsetY += 18;
            } else if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 18) {
                offsetY += 36;
            }
            context.blit(TEXTURE, posX, posY, 0, offsetY, 16, 18);
        }
    }

    private void renderRecipeIcons(GuiGraphics context, int x, int y, int scrollOffsetOFF) {
        List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.menu).getAvailableRecipes().stream().map(RecipeHolder::value).toList();
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.menu).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int k = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int m = y + 18 * l + 1;
            assert (this.minecraft != null);
            assert (this.minecraft.level != null);
            context.renderItem(list.get(i).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), k, m);
        }
    }

    protected void renderTooltip(GuiGraphics context, int x, int y) {
        super.renderTooltip(context, x, y);
        if (this.canCraft) {
            int i = this.leftPos + 58;
            int j = this.topPos + 15;
            int scrollOffsetOFF = this.scrollOffset + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.menu).getAvailableRecipes().stream().map(RecipeHolder::value).toList();
            for (int l = this.scrollOffset; l < scrollOffsetOFF && l < ((WoodcutterGuiHandler)this.menu).getAvailableRecipeCount(); ++l) {
                int offsetedL = l - this.scrollOffset;
                int n = i + offsetedL % 4 * 16;
                int o = j + offsetedL / 4 * 18;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                assert (this.minecraft != null);
                assert (this.minecraft.level != null);
                context.renderTooltip(this.font, list.get(l).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), x, y);
            }
        }
    }

    private void onInventoryChange() {
        this.canCraft = ((WoodcutterGuiHandler)this.menu).canCraft();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.leftPos + 58;
            int j = this.topPos + 15;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int offsetedL = l - this.scrollOffset;
                double d = mouseX - (double)(i + offsetedL % 4 * 16);
                double e = mouseY - (double)(j + offsetedL / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WoodcutterGuiHandler)this.menu).clickMenuButton((Player)Objects.requireNonNull(this.minecraft).player, l))) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                assert (this.minecraft.gameMode != null);
                this.minecraft.gameMode.handleInventoryButtonClick(((WoodcutterGuiHandler)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 124;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 11) && mouseY >= (double)j && mouseY < (double)(j + 58)) {
                this.mouseClicked = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.topPos + 15;
            int j = i + 58;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = Mth.clamp((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)amountY / (float)i;
            this.scrollAmount = Mth.clamp((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((WoodcutterGuiHandler)this.menu).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((WoodcutterGuiHandler)this.menu).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    protected void init() {
        super.init();
    }
}

