/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.CompletionistBannerBlock;
import org.jetbrains.annotations.NotNull;

public class CompletionistWallBannerBlock
extends CompletionistBannerBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)CompletionistWallBannerBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.NORTH, (Object)CompletionistWallBannerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.EAST, (Object)CompletionistWallBannerBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.WEST, (Object)CompletionistWallBannerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.5, (double)16.0)));

    public CompletionistWallBannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void makeDefaultState() {
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    @Override
    public boolean canSurvive(@NotNull BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos.relative((Direction)blockState.getValue((Property)FACING))).isSolid();
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState blockState, @NotNull Direction direction, @NotNull BlockState blockState2, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPos, @NotNull BlockPos blockPos2) {
        if (direction == blockState.getValue((Property)FACING) && !blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPES.get(blockState.getValue((Property)FACING));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = this.defaultBlockState();
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            Direction oppositeDirection;
            BlockState oppositeState;
            if (!direction.getAxis().isHorizontal() || !(oppositeState = (BlockState)blockState.setValue((Property)FACING, (Comparable)(oppositeDirection = direction.getOpposite()))).canSurvive((LevelReader)level, blockPos)) continue;
            return oppositeState;
        }
        return null;
    }

    @Override
    @NotNull
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    @Override
    @NotNull
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

