/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.meadow.core.block.TiledStoveBlock;
import net.satisfy.meadow.core.block.TiledStoveBlockSmoker;
import org.jetbrains.annotations.NotNull;

public class TiledStoveBlockFireplace
extends TiledStoveBlock {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");

    public TiledStoveBlockFireplace(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TiledStoveBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        boolean isLit = (Boolean)state.getValue((Property)TiledStoveBlock.LIT);
        boolean isFlint = stack.getItem() instanceof FlintAndSteelItem;
        if (stack.is(ItemTags.PICKAXES)) {
            BlockState next = (BlockState)state.cycle((Property)TOP);
            level.setBlockAndUpdate(pos, next);
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)next));
            level.playSound(null, pos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (isLit && stack.is(ItemTags.SHOVELS)) {
            this.propagateLit(level, pos, false);
            level.levelEvent(null, 1009, pos, 0);
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!isLit && (isFlint || stack.getItem() instanceof FireChargeItem)) {
            this.propagateLit(level, pos, true);
            if (!player.getAbilities().instabuild) {
                if (isFlint) {
                    stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                } else {
                    stack.shrink(1);
                }
            }
            level.playSound(null, pos, isFlint ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)TiledStoveBlock.LIT)).booleanValue()) {
            double centerX = (double)pos.getX() + 0.5;
            double centerY = (double)pos.getY() + 0.24;
            double centerZ = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(centerX, centerY, centerZ, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.5f, 0.5f, false);
            }
            level.playLocalSound(centerX, centerY, centerZ, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 0.5f, 0.5f, false);
            Direction facing = (Direction)state.getValue((Property)FACING);
            Direction.Axis axis = facing.getAxis();
            double offset = random.nextDouble() * 0.6 - 0.3;
            double ox = axis == Direction.Axis.X ? (double)facing.getStepX() * 0.52 : offset;
            double oy = random.nextDouble() * 6.0 / 16.0;
            double oz = axis == Direction.Axis.Z ? (double)facing.getStepZ() * 0.52 : offset;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, centerX + ox, centerY + oy, centerZ + oz, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, centerX + ox, centerY + oy, centerZ + oz, 0.0, 0.0, 0.0);
            double topY = (double)pos.getY() + 1.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, centerX, topY, centerZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TOP});
    }

    private void propagateLit(Level level, BlockPos origin, boolean lit) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(origin);
        visited.add(origin);
        block5: while (!queue.isEmpty()) {
            BlockPos blockPos = (BlockPos)queue.removeFirst();
            BlockState blockState = level.getBlockState(blockPos);
            Direction[] block = blockState.getBlock();
            Objects.requireNonNull(block);
            Direction[] directionArray = block;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TiledStoveBlockFireplace.class, TiledStoveBlockSmoker.class, TiledStoveBlock.class}, (Object)directionArray, n)) {
                case 0: {
                    TiledStoveBlockFireplace fireplace = (TiledStoveBlockFireplace)directionArray;
                    if ((Boolean)blockState.getValue((Property)TiledStoveBlock.LIT) == lit) break;
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)TiledStoveBlock.LIT, (Comparable)Boolean.valueOf(lit)));
                    break;
                }
                case 1: {
                    TiledStoveBlockSmoker smoker = (TiledStoveBlockSmoker)directionArray;
                    if (!blockState.hasProperty((Property)SmokerBlock.LIT) || (Boolean)blockState.getValue((Property)SmokerBlock.LIT) == lit) break;
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)SmokerBlock.LIT, (Comparable)Boolean.valueOf(lit)));
                    break;
                }
                case 2: {
                    TiledStoveBlock tiled = (TiledStoveBlock)directionArray;
                    if (!blockState.hasProperty((Property)TiledStoveBlock.LIT) || (Boolean)blockState.getValue((Property)TiledStoveBlock.LIT) == lit) break;
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)TiledStoveBlock.LIT, (Comparable)Boolean.valueOf(lit)));
                    break;
                }
                default: {
                    continue block5;
                }
            }
            for (Direction direction : Direction.values()) {
                Block neighborBlock;
                BlockPos neighborPos = blockPos.relative(direction);
                if (!visited.add(neighborPos) || !((neighborBlock = level.getBlockState(neighborPos).getBlock()) instanceof TiledStoveBlockSmoker) && !(neighborBlock instanceof TiledStoveBlock)) continue;
                queue.addLast(neighborPos);
            }
        }
    }
}

