/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.block.CookingCauldronBlock;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronBlockEntity
extends BlockEntity
implements ImplementedInventory,
MenuProvider {
    private static final int MAX_CAPACITY = 8;
    private static final int OUTPUT_SLOT = 0;
    public static final int MAX_COOKING_TIME = 200;
    private static final int INGREDIENTS_START = 1;
    private static final int INGREDIENTS_END = 6;
    private static final int FLUID_INPUT_SLOT = 7;
    private static final int[] SLOTS_FOR_REST = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 7};
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private int cookingTime;
    private boolean isBeingBurned;
    private int fluidLevel;
    private int currentCraftingDuration;
    private boolean fluidInputProcessed;
    private final ContainerData delegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CookingCauldronBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingCauldronBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> CookingCauldronBlockEntity.this.fluidLevel;
                case 3 -> CookingCauldronBlockEntity.this.currentCraftingDuration;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CookingCauldronBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingCauldronBlockEntity.this.isBeingBurned = value != 0;
                    break;
                }
                case 2: {
                    CookingCauldronBlockEntity.this.fluidLevel = value;
                    break;
                }
                case 3: {
                    CookingCauldronBlockEntity.this.currentCraftingDuration = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public CookingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.COOKING_CAULDRON.get(), pos, state);
    }

    private RegistryAccess registries() {
        return this.level != null ? this.level.registryAccess() : RegistryAccess.EMPTY;
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_REST;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        this.cookingTime = compoundTag.getInt("CookingTime");
        this.isBeingBurned = compoundTag.getBoolean("IsBeingBurned");
        this.fluidLevel = compoundTag.getInt("FluidLevel");
        this.currentCraftingDuration = compoundTag.getInt("CurrentCraftingDuration");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putInt("CookingTime", this.cookingTime);
        compoundTag.putBoolean("IsBeingBurned", this.isBeingBurned);
        compoundTag.putInt("FluidLevel", this.fluidLevel);
        compoundTag.putInt("CurrentCraftingDuration", this.currentCraftingDuration);
    }

    public boolean isBeingBurned() {
        if (this.getLevel() == null) {
            throw new NullPointerException("Null world invoked");
        }
        if (((Boolean)this.getBlockState().getValue((Property)CookingCauldronBlock.HANGING)).booleanValue()) {
            return true;
        }
        Optional optionalList = BuiltInRegistries.BLOCK.getTag(TagRegistry.ALLOWS_COOKING);
        HolderSet.Named entryList = optionalList.orElse(null);
        return entryList != null && entryList.contains((Holder)this.getLevel().getBlockState(this.getBlockPos().below()).getBlock().builtInRegistryHolder());
    }

    private boolean canCraft(CookingCauldronRecipe recipe) {
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)this.registries()).isEmpty()) {
            return false;
        }
        ItemStack outputSlotStack = this.getItem(0);
        return outputSlotStack.isEmpty() || ItemStack.isSameItem((ItemStack)outputSlotStack, (ItemStack)recipe.getResultItem((HolderLookup.Provider)this.registries())) && outputSlotStack.getCount() < outputSlotStack.getMaxStackSize();
    }

    private void craft(CookingCauldronRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack recipeOutput = recipe.assemble();
        ItemStack outputSlotStack = this.getItem(0);
        if (outputSlotStack.isEmpty()) {
            this.setItem(0, recipeOutput.copy());
        } else if (ItemStack.isSameItem((ItemStack)outputSlotStack, (ItemStack)recipe.getResultItem((HolderLookup.Provider)this.registries())) && outputSlotStack.getCount() < outputSlotStack.getMaxStackSize()) {
            outputSlotStack.grow(recipeOutput.getCount());
        }
        boolean[] ingredientUsed = new boolean[7];
        block0: for (Ingredient ingredient : recipe.getIngredients()) {
            for (int slotIndex = 1; slotIndex <= 6; ++slotIndex) {
                if (ingredientUsed[slotIndex] || !ingredient.test(this.getItem(slotIndex))) continue;
                ingredientUsed[slotIndex] = true;
                ItemStack stackInSlot = this.getItem(slotIndex);
                ItemStack remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.shrink(1);
                if (remainderStack.isEmpty()) continue block0;
                if (stackInSlot.isEmpty()) {
                    this.setItem(slotIndex, remainderStack);
                    continue block0;
                }
                this.handleRemainder(remainderStack, slotIndex);
                continue block0;
            }
        }
        this.consumeFluid(recipe.getFluidAmount());
    }

    private void handleRemainder(ItemStack remainderStack, int originalSlot) {
        if (originalSlot == 7) {
            ItemStack currentFluidSlot = this.getItem(7);
            if (currentFluidSlot.isEmpty()) {
                this.setItem(7, remainderStack.copy());
            } else {
                this.dropItemIntoWorld(remainderStack, this.worldPosition);
            }
            return;
        }
        boolean added = false;
        for (int i = 1; i <= 6; ++i) {
            ItemStack is = this.getItem(i);
            if (is.isEmpty()) {
                this.setItem(i, remainderStack.copy());
                added = true;
                break;
            }
            if (!ItemStack.isSameItem((ItemStack)is, (ItemStack)remainderStack) || is.getCount() + remainderStack.getCount() > is.getMaxStackSize()) continue;
            is.grow(remainderStack.getCount());
            added = true;
            break;
        }
        if (!added) {
            this.dropItemIntoWorld(remainderStack, this.worldPosition);
        }
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        }
        return ItemStack.EMPTY;
    }

    private void dropItemIntoWorld(ItemStack itemStack, BlockPos pos) {
        if (this.level != null && !this.level.isClientSide()) {
            double offsetX = this.level.random.nextDouble() * 0.7 + 0.15;
            double offsetY = this.level.random.nextDouble() * 0.5 + 0.1;
            double offsetZ = this.level.random.nextDouble() * 0.7 + 0.15;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, itemStack);
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    private void processFluidInput() {
        ItemStack fluidItem = this.getItem(7);
        if (!fluidItem.isEmpty()) {
            boolean processed = false;
            int fluidAmount = 0;
            if (fluidItem.is(TagRegistry.SMALL_WATER_FILL)) {
                fluidAmount = 25;
                processed = true;
            } else if (fluidItem.is(TagRegistry.LARGE_WATER_FILL)) {
                fluidAmount = 50;
                processed = true;
            }
            if (processed) {
                ItemStack consumedItem = fluidItem.split(1);
                this.setItem(7, fluidItem);
                ItemStack remainder = this.getRemainderItem(consumedItem);
                if (!remainder.isEmpty()) {
                    this.handleRemainder(remainder, 7);
                }
                this.addFluid(fluidAmount);
                this.setChanged();
            }
        }
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        ItemStack fluidItem;
        if (world.isClientSide()) {
            return;
        }
        if (!this.fluidInputProcessed) {
            this.processFluidInput();
            this.fluidInputProcessed = true;
        }
        if ((fluidItem = this.getItem(7)).isEmpty() || !fluidItem.is(TagRegistry.SMALL_WATER_FILL) && !fluidItem.is(TagRegistry.LARGE_WATER_FILL)) {
            this.fluidInputProcessed = false;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned && ((Boolean)state.getValue((Property)CookingCauldronBlock.LIT)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        RecipeHolder recipe = world.getRecipeManager().getRecipeFor((RecipeType)RecipeRegistry.COOKING.get(), (RecipeInput)CraftingInput.of((int)1, (int)6, (List)this.inventory.subList(1, 7)), world).orElse(null);
        if (recipe != null && this.canCraft((CookingCauldronRecipe)recipe.value()) && this.fluidLevel >= ((CookingCauldronRecipe)recipe.value()).getFluidAmount()) {
            if (this.currentCraftingDuration == 0 && this.cookingTime == 0) {
                this.currentCraftingDuration = ((CookingCauldronRecipe)recipe.value()).getCraftingDuration() * 20;
                this.delegate.set(3, this.currentCraftingDuration);
            }
            ++this.cookingTime;
            this.delegate.set(0, this.cookingTime);
            if (this.cookingTime >= this.currentCraftingDuration) {
                this.cookingTime = 0;
                this.currentCraftingDuration = 0;
                this.delegate.set(3, this.currentCraftingDuration);
                this.craft((CookingCauldronRecipe)recipe.value());
            }
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(true))).setValue((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.cookingTime = 0;
            this.currentCraftingDuration = 0;
            this.delegate.set(0, this.cookingTime);
            this.delegate.set(3, this.currentCraftingDuration);
            if (((Boolean)state.getValue((Property)CookingCauldronBlock.COOKING)).booleanValue()) {
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(false))).setValue((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public boolean stillValid(Player player) {
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)ObjectRegistry.COOKING_CAULDRON.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new CookingCauldronGuiHandler(syncId, inv, (Container)this, this.delegate);
    }

    public int getFluidLevel() {
        return Math.min(this.fluidLevel, 100);
    }

    private void addFluid(int amount) {
        this.fluidLevel = Math.min(this.fluidLevel + amount, 100);
        this.delegate.set(2, this.fluidLevel);
    }

    private void consumeFluid(int amount) {
        this.fluidLevel = Math.max(this.fluidLevel - amount, 0);
        this.delegate.set(2, this.fluidLevel);
    }
}

