/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;

public class WaterBuffaloEntity
extends Cow {
    public WaterBuffaloEntity(EntityType<? extends Cow> entityType, Level world) {
        super(entityType, world);
    }

    public Cow getBreedOffspring(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (Cow)((EntityType)EntityTypeRegistry.WATER_BUFFALO.get()).create((Level)serverWorld);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)ObjectRegistry.WOODEN_BUCKET.get()) && !this.isBaby()) {
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)((Item)ObjectRegistry.WOODEN_BUFFALO_MILK_BUCKET.get()).getDefaultInstance());
            player.setItemInHand(hand, itemStack2);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEventRegistry.BUFFALO_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.BUFFALO_HURT.get();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundEventRegistry.BUFFALO_DEATH.get();
    }

    public int getMaxHeadYRot() {
        return 35;
    }
}

