/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class WoodcuttingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient input;
    private final ItemStack outputStack;

    public WoodcuttingRecipe(ItemStack itemStack, Ingredient ingredient) {
        this.outputStack = itemStack;
        this.input = ingredient;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.input.test(recipeInput.getItem(0));
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.outputStack.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.outputStack.copy();
    }

    public ItemStack getResultItem() {
        return this.getResultItem(null);
    }

    public ItemStack getOutputStack() {
        return this.getResultItem(null);
    }

    public boolean isSpecial() {
        return true;
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"meadow", (String)"woodcutting");
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.WOODCUTTING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.WOODCUTTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<WoodcuttingRecipe> {
        public static final MapCodec<WoodcuttingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("outputItem").forGetter(recipe -> recipe.outputStack), (App)Ingredient.CODEC.fieldOf("inputItem").forGetter(WoodcuttingRecipe::getInput)).apply((Applicative)instance, WoodcuttingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WoodcuttingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, WoodcuttingRecipe::getOutputStack, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, WoodcuttingRecipe::getInput, WoodcuttingRecipe::new);

        @NotNull
        public MapCodec<WoodcuttingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WoodcuttingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

