/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.neoforge.client;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.MeadowClient;
import net.satisfy.meadow.client.gui.CheeseFormGui;
import net.satisfy.meadow.client.gui.CookingCauldronGui;
import net.satisfy.meadow.client.gui.WoodcutterGui;
import net.satisfy.meadow.core.entity.PineBoatEntity;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.neoforge.client.extensions.FurArmorBootsExtensions;
import net.satisfy.meadow.neoforge.client.extensions.FurArmorChestplateExtensions;
import net.satisfy.meadow.neoforge.client.extensions.FurArmorHatExtensions;
import net.satisfy.meadow.neoforge.client.extensions.FurArmorLeggingsExtensions;

@EventBusSubscriber(modid="meadow", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class MeadowClientNeoForge {
    @SubscribeEvent
    public static void beforeClientSetup(RegisterEvent event) {
        MeadowClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MeadowClient.initClient();
    }

    @SubscribeEvent
    public static void onClientSetup(RegisterMenuScreensEvent event) {
        event.register((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), CheeseFormGui::new);
        event.register((MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get(), WoodcutterGui::new);
        event.register((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), CookingCauldronGui::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (PineBoatEntity.Type type : PineBoatEntity.Type.values()) {
            event.registerLayerDefinition(new ModelLayerLocation(Meadow.identifier(type.getModelLocation()), "main"), BoatModel::createBodyModel);
            event.registerLayerDefinition(new ModelLayerLocation(Meadow.identifier(type.getChestModelLocation()), "main"), ChestBoatModel::createBodyModel);
        }
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new FurArmorHatExtensions(), new Item[]{(Item)ObjectRegistry.FUR_HELMET.get()});
        event.registerItem((IClientItemExtensions)new FurArmorChestplateExtensions(), new Item[]{(Item)ObjectRegistry.FUR_CHESTPLATE.get()});
        event.registerItem((IClientItemExtensions)new FurArmorLeggingsExtensions(), new Item[]{(Item)ObjectRegistry.FUR_LEGGINGS.get()});
        event.registerItem((IClientItemExtensions)new FurArmorBootsExtensions(), new Item[]{(Item)ObjectRegistry.FUR_BOOTS.get()});
    }
}

