/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.candlelight.client.gui.NoteGui;
import net.satisfy.candlelight.core.block.entity.TypewriterEntity;
import net.satisfy.candlelight.core.networking.packet.SyncTypewriterDataC2SPacket;
import net.satisfy.candlelight.core.registry.SoundEventRegistry;

@OnlyIn(value=Dist.CLIENT)
public class TypeWriterGui
extends NoteGui {
    private final TypewriterEntity typewriterEntity;
    private float lineProgressLocal = 0.0f;
    private static final int MAX_CHARS_PER_LINE = 19;
    private int charsInLine = 0;

    public TypeWriterGui(Player player, TypewriterEntity typewriterEntity) {
        super(player, typewriterEntity.getPaper());
        this.typewriterEntity = typewriterEntity;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        assert (this.minecraft != null);
        this.minecraft.gameRenderer.processBlurEffect(delta);
        this.minecraft.getMainRenderTarget().bindWrite(false);
        super.render(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
    }

    protected void renderBlurredBackground(float f) {
    }

    public void removed() {
        super.removed();
        this.typewriterEntity.snapRoller();
        this.typewriterEntity.setLineProgress(0.0f);
        this.charsInLine = 0;
        this.lineProgressLocal = 0.0f;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        boolean result = super.charTyped(chr, modifiers);
        if (!result) {
            return false;
        }
        if (chr == '\n' || chr == '\r') {
            return true;
        }
        if (chr == ' ') {
            this.typewriterEntity.triggerSpace();
        } else {
            this.typewriterEntity.triggerKeyBounce();
        }
        ++this.charsInLine;
        if (this.charsInLine >= 19) {
            this.typewriterEntity.snapRoller();
            this.charsInLine = 0;
            this.lineProgressLocal = 0.0f;
            this.typewriterEntity.setLineProgress(0.0f);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_BELL, (float)1.0f));
            super.charTyped('\n', 0);
        } else {
            this.lineProgressLocal = (float)this.charsInLine / 19.0f;
            this.typewriterEntity.setLineProgress(this.lineProgressLocal);
        }
        this.playTypingSound();
        return true;
    }

    @Override
    protected void finalizeNote(boolean signNote) {
        if (this.dirty) {
            this.removeEmptyPages();
            this.writeNbtData(signNote);
        }
        CompoundTag nbt = ((CustomData)this.itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        BlockPos pos = this.typewriterEntity.getBlockPos();
        NetworkManager.sendToServer((CustomPacketPayload)new SyncTypewriterDataC2SPacket(nbt, pos, signNote));
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean result = super.keyPressed(keyCode, scanCode, modifiers);
        if (!result) {
            return false;
        }
        if (keyCode == 257) {
            this.typewriterEntity.triggerEnter();
            this.typewriterEntity.snapRoller();
            this.charsInLine = 0;
            this.lineProgressLocal = 0.0f;
            this.typewriterEntity.setLineProgress(0.0f);
            this.playEnterSound();
            return true;
        }
        if (keyCode == 259) {
            if (this.charsInLine > 0) {
                --this.charsInLine;
                this.lineProgressLocal = (float)this.charsInLine / 19.0f;
                this.typewriterEntity.setLineProgress(this.lineProgressLocal);
            }
            this.playTypingSound();
            return true;
        }
        this.playTypingSound();
        return true;
    }

    private void playEnterSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_BELL, (float)1.0f));
    }

    private void playTypingSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEventRegistry.TYPEWRITER.get()), (float)2.0f));
    }
}

