/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.candlelight.core.util.CandlelightIdentifier;
import org.jetbrains.annotations.NotNull;

public class CookingChestplateModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(CandlelightIdentifier.identifier("cooking_chest"), "main");
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public CookingChestplateModel(ModelPart root) {
        this.body = root.getChild("body");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 36).addBox(-4.0f, 10.0f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.325f)).texOffs(16, 16).addBox(-4.0f, -1.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -3.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -3.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int alpha) {
        poseStack.pushPose();
        this.body.render(poseStack, buffer, packedLight, packedOverlay, alpha);
        this.right_arm.render(poseStack, buffer, packedLight, packedOverlay, alpha);
        this.left_arm.render(poseStack, buffer, packedLight, packedOverlay, alpha);
        this.right_leg.render(poseStack, buffer, packedLight, packedOverlay, alpha);
        this.left_leg.render(poseStack, buffer, packedLight, packedOverlay, alpha);
        poseStack.popPose();
    }

    public void setupAnim(@NotNull T entity, float f, float g, float h, float i, float j) {
    }

    public void copyBody(ModelPart baseBody, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        this.body.copyFrom(baseBody);
        this.left_arm.copyFrom(leftArm);
        this.right_arm.copyFrom(rightArm);
        this.left_leg.copyFrom(leftLeg);
        this.right_leg.copyFrom(rightLeg);
    }
}

